

#include <iostream.h>
#include <strstream.h>
#include <memory.h>
#include "Debug.h"
#include "Input.h"

short   Debug::debug_mode=0;
StrList Debug::function_breakpoints;
StrList Debug::method_breakpoints;

static char buf[0xff];



Debug::Debug(Stmt& stmt) : old_debug_state(debug_mode) {
  if(debug_mode) {
    cout << "--> ";
    stmt.Trace();
    Prompt();
  }
}

Debug::Debug(Expr& expr, char* name) : old_debug_state(debug_mode) {
  if(debug_mode) {
    cout << "--> ";
    expr.Print();
    Prompt();
    return;
  }
  if(name) {
    if(strstr(name, "::")) {     // method
      if(DoesMethodHaveBreakpoint(name)) {
	cout << "--> ";
	expr.Print();
	Prompt();
      }
    }
    else {                       // function
      if(DoesFunctionHaveBreakpoint(name)) {
	cout << "--> ";
	expr.Print();
	Prompt();
      }
    }
  }
}


void Debug::Prompt() {
  Input* input=Input::GetInput();
  short  old_deb;
  while(1) {
    cout << "(debugger)> ";
    memset(buf, 0, sizeof(buf));
    cin.getline(buf, sizeof(buf));
    
    switch(buf[0]) {
    case 'n':
      debug_mode=0;
      return;
    case 's':
      return;
    case 'r':
      Run();
      return;
    case 'b':
      AddBreakpoint(buf);
      break;
    default:
      old_deb=debug_mode;
      debug_mode=0;
      InterpretString(buf);
      debug_mode=old_deb;
      break;
    }    
  }  
}

  
Debug::~Debug() {
  debug_mode=old_debug_state; // reset previous debugging flag
}


void Debug::Run() {
  old_debug_state=0;
}


void Debug::AddBreakpoint(char* name) {
  name++;
  istrstream in(name);
  in >> ws;
  DynamicString d;
  d.ReadToken(in);
  char* input=strdup(d), *tmp=0;

  tmp=strstr(input, "::");
  if(tmp) {    // method call
    Debug::method_breakpoints.Add(strdup(input));
  }
  else {       // function call
    Debug::function_breakpoints.Add(strdup(input));
  }
  delete [] input;  
}



bool Debug::DoesFunctionHaveBreakpoint(char* name) {
  DO(Debug::function_breakpoints, char*, item)
    if(!strcmp(item, name))
      return true;
  OD
  return false;
}


bool Debug::DoesMethodHaveBreakpoint(char* name) {
  DO(Debug::method_breakpoints, char*, item)
    if(!strcmp(item, name))
      return true;
  OD
  return false;
}
