#ifndef DEBUG_H
#define DEBUG_H

class Debug;

#include "Grammar.h"

typedef CL_List<char*> StrList;

class Debug {
  short           old_debug_state;
public:
  static short    debug_mode;
  static StrList  function_breakpoints;
  static StrList  method_breakpoints;
                  Debug(Stmt&);
                  Debug(Expr&, char* name=0);
  virtual         ~Debug();
  void            Prompt();
  void            Run();
  void            AddBreakpoint(char*);
  bool            DoesFunctionHaveBreakpoint(char* name);
  bool            DoesMethodHaveBreakpoint(char* name);
};


#endif

