
#include "DynamicString.h"
#include <stdio.h>
#include <string.h>
#ifdef _AIX
#include <strings.h>
#endif
#include <memory.h>

DynamicString::DynamicString(long initial_size, long grow_size) 
                           : INITIAL_SIZE(initial_size), GROW_SIZE(grow_size),
                             curr_size(0), max_size(initial_size) {
  str=new char[initial_size];
  bzero(str, initial_size);
}



DynamicString& operator<<(DynamicString& d, char* s) {
  int len=strlen(s);
  if(!len)
    return d;
  if(d.curr_size+len >= d.max_size) {
    if(len > d.GROW_SIZE)
      d.Grow(len);
    else
      d.Grow(d.GROW_SIZE);
  }
  strcpy(&(d.str[d.curr_size]), s);
  d.curr_size+=len;
  return d;
}


DynamicString& operator<<(DynamicString& d, const char* s) {
  return operator<<(d, (char*)s);
}



DynamicString& operator<<(DynamicString& d, char c) {
  if(d.curr_size+2 >= d.max_size)
    d.Grow(d.GROW_SIZE);
  d.str[d.curr_size++]=c;
  d.str[d.curr_size]=0;
  return d;
}


DynamicString& operator<<(DynamicString& d, int i) {
  char buf[16];
  sprintf(buf, "%d", i);
  return operator<<(d, (char*)buf);
}


DynamicString& operator<<(DynamicString& d, long l) {
  char buf[16];
  sprintf(buf, "%li", l);
  return operator<<(d, (char*)buf);
}


void DynamicString::ReadToken(istream& is) {
    char c;
    is >> ws;  // eat white space before first token
    while(!is.eof()) {
	is.get(c);
	if(is.eof())
	  break;
	if(c == ' ' || c == EOF)
	    break;
	if(c == '\n')
	  continue;
	operator<<(*this, c);
    }
    //    operator<<(*this,  '\0');  // ?
    is >> ws;
}


void DynamicString::Grow(long delta) {
  long new_size=max_size=curr_size+delta+1;
  char* new_str=new char[new_size];
  bzero(new_str, new_size);
  for(long i=0; i < curr_size; i++)
    new_str[i]=str[i];
  delete [] str;
  str=new_str;
}
