#ifndef DYNAMIC_STRING_H
#define DYNAMIC_STRING_H

#include <iostream.h>

class DynamicString {
  const long            INITIAL_SIZE;
  const long            GROW_SIZE;
  char*                 str;
  long                  curr_size, max_size;
protected:
  void                  Grow(long delta);
public:
                        DynamicString(long initial_size=64, long grow_size=128);
			 ~DynamicString() {delete [] str;}
                        operator char*()  {return str;}
  friend DynamicString& operator<<(DynamicString&, char*);
  friend DynamicString& operator<<(DynamicString&, const char*);
  friend DynamicString& operator<<(DynamicString&, char);
  friend DynamicString& operator<<(DynamicString&, long);
  friend DynamicString& operator<<(DynamicString&, int);
  void                  ReadToken(istream&);
  void                  Reset()           {delete [] str; str=0; curr_size=0; max_size=INITIAL_SIZE;}
  long                  Size()            {return curr_size;}
  long                  MaxSize()         {return max_size;}
};



#endif

