
#include <string.h>
#include "Input.h"

Input* Input::_inp;

extern short interactive;
extern short prompt;


class InputSource {
public:
                   InputSource() {}
    virtual        ~InputSource() {}
    virtual char   GetChar()=0;
};

class StdInput : public InputSource {
public:
                   StdInput() {}
                   ~StdInput() {}
    char           GetChar() {return getchar();}
};


class FileInput : public InputSource {
    FILE*          _fp;
public:
                   FileInput(FILE* fp);
                   ~FileInput();
    char           GetChar();
};

class StreamInput : public InputSource {
    istream*       _is;
public:
                   StreamInput(istream& is);
                   ~StreamInput();
    char           GetChar();
};

class StringInput : public InputSource {
    char*          _str;
    char*          _curr;
public:
                   StringInput(char* inp);
                   ~StringInput();
    char           GetChar();
};



FileInput::FileInput(FILE* fp) : _fp(fp) {}

FileInput::~FileInput() {
    if(_fp)
	fclose(_fp);
}

char FileInput::GetChar() {
    if(!_fp)
	return 0;
    int c=fgetc(_fp);
    return c == EOF? 0 : (char)c;
}


StreamInput::StreamInput(istream& is) : _is(&is) {}

StreamInput::~StreamInput() {}

char StreamInput::GetChar() {
    char c;
    if(!_is)
	return 0;
    c=_is->get();
    return (char)c;
}


StringInput::StringInput(char* str) : _str(0) {
    if(str)
	_str=strdup(str);
    _curr=_str;
}

StringInput::~StringInput() {
    delete [] _str;
}

char StringInput::GetChar() {
    if(!*_curr)
	return 0;
    return *_curr++;
}







Input::Input() : _nesting_level(0) {
    _stack.Add(new StdInput);
}


Input::~Input() {
    if(_stack.Size()) {
	DO(_stack, InputSource*, item)
	    delete item;
	OD
    }
}

Input* Input::GetInput() {
    if(!Input::_inp)
	Input::_inp=new Input();
    return Input::_inp;
}


char Input::GetChar() {
    if(IsEmpty())
	return 0;
    char ret;
    InputSource* curr=_stack[0];
    if(curr) {
	ret=curr->GetChar();
	if(ret == 0) {
	    Pop();
	    if(_nesting_level > 0) {
	      _nesting_level--;
	      return 0;
	    }
	    else {
	      if(_stack.Size() == 1) {
		interactive=1;
		prompt=1;
	      }
	      return GetChar();	      
	    }

	}
	else
	    return ret;
    }
    return 0;  // should never be reached...
}

void Input::Push(istream& is) {
    StreamInput* tmp=new StreamInput(is);
    _stack.Add(tmp, head, normal);  // Add at head, we want to emulate a stack !
}

void Input::Push(FILE* fp) {
    FileInput* tmp=new FileInput(fp);
    _stack.Add(tmp, head, normal);
}

void Input::Push(char* str) {
    StringInput* tmp=new StringInput(str);
    _stack.Add(tmp, head, normal);
}

void Input::Pop() {
    if(_stack.Size()) {
	InputSource* curr=_stack[0];
	_stack.RemoveAt(0);
	delete curr;
    }
}

bool Input::IsEmpty() {
    return (_stack.Size() == 0) ? true : false;
}


void Input::IncrNestingLevel() {
  _nesting_level++;
}
