#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <strings.h>
#include <iostream.h>
#include <fstream.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>

#ifdef _AIX
  #include <sys/select.h>
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#include "DynamicString.h"


void Credentials() {
  printf("\n          ----------------------------------------------------------\n"   );
  printf("             SendAgent front end to GOMscript-interpreter written by \n"  );
  printf("                                 Bela Ban\n"                           );
  printf("                       IBM Zurich Research Laboratory\n"               );
  printf("                              bba@zurich.ibm.com\n"                    );
  printf("                                  Version 0.7\n"                       );
  printf("                       Built on %s at %s\n",	__DATE__, __TIME__       );
  printf("          ----------------------------------------------------------\n\n\n" );  
}



int main(int argc, char* argv[]) {
  int                 socket_descr, rc;
  struct sockaddr_in  addr, from;  /* Internet type of socket address is used */
  int                 from_len, bytes, numbytes;
  char                buffer[0xff];
  char*               host_name=0;
  int                 port_number=0;
  char*               scriptname=0, *initial_functions=0, *symtab_name=0;
  struct hostent*     h_ent;
  static char         send_buf[0xffff];
  fd_set              fd;

  if(argc != 6 || !strncmp(argv[1], "-h", 2)) {
    printf("Usage: \"%s\" <hostname> <port> <script filename> "
	   "<initial functions filename> <symbol table filename>\n", argv[0]);
    return -1;
  }

  host_name=argv[1];
  port_number=atoi(argv[2]);
  scriptname=argv[3];
  initial_functions=argv[4];
  symtab_name=argv[5];


  h_ent=gethostbyname(host_name);
  if(!h_ent) {
    printf("%s is not a known host !\n", host_name);
    return -1;
  }
  
  socket_descr=socket(AF_INET, SOCK_STREAM, 0);
  if(socket_descr == -1) {
    printf("Socket could not be created !\n");
    return -1;
  }

  bzero((char*)&addr, sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_addr.s_addr=((struct in_addr*)h_ent->h_addr_list[0])->s_addr;
  addr.sin_port=htons(port_number);
  #ifndef __linux__
  addr.sin_len=sizeof(addr);
  #endif
  rc=connect(socket_descr, (struct sockaddr*)&addr, sizeof(addr));
  if(rc) {
    perror("Interpreter client");
    return rc;
  }

  cout << "Connection to GOMscript server on host " << host_name;
  cout << " at port " << port_number << " made.\n" << endl;


  /* ====================================================================== 
                                    Script
     ====================================================================== */
  
  if(!strlen(scriptname)) {
    memset(send_buf, 0, sizeof(send_buf));
    sprintf(send_buf, "<SCRIPT></SCRIPT>");
    write(socket_descr, send_buf, strlen(send_buf));    
  }
  else {
    cout << "Sending script \"" << scriptname << "."; cout.flush();

    DynamicString d;
    ifstream ifs(scriptname);
    if(!ifs)
      cerr << "File \"" << scriptname << "\" could not be opened !" << endl;
    else {
      d << "<SCRIPT>";
      char c;
      
      while(!ifs.eof()) {
	ifs.get(c);
	if(ifs)
	  d << c;
      }

      d << "</SCRIPT>";

      long len=d.Size(), n=0;
      char* tmp=(char*)d;
      for(long bytes_to_write=0; bytes_to_write < len; bytes_to_write+=n)
	n=write(socket_descr, tmp+bytes_to_write, strlen(tmp)-bytes_to_write);

      //      write(socket_descr, (char*)d, d.Size());

    }    
    cout << "\nOK.\n" << endl;    
  }


  /* ====================================================================== 
                                Initial functions
     ====================================================================== */
  
  if(!strlen(initial_functions)) {
    memset(send_buf, 0, sizeof(send_buf));
    sprintf(send_buf, "<INITIAL_FUNCTIONS></INITIAL_FUNCTIONS>");
    write(socket_descr, send_buf, strlen(send_buf));    
  }
  else {
    cout << "Sending initial_functions from file \"" << initial_functions << "\"."; 
    cout.flush();

    DynamicString d;
    ifstream ifs(initial_functions);
    if(!ifs)
      cerr << "File \"" << initial_functions << "\" could not be opened !" << endl;
    else {
      d << "<INITIAL_FUNCTIONS>";
      char c;
      
      while(!ifs.eof()) {
	ifs.get(c);
	if(ifs)
	  d << c;
      }

      d << "</INITIAL_FUNCTIONS>";
      long len=d.Size(), n=0;
      char* tmp=(char*)d;
      for(long bytes_to_write=0; bytes_to_write < len; bytes_to_write+=n)
	n=write(socket_descr, tmp+bytes_to_write, strlen(tmp)-bytes_to_write);

      //      write(socket_descr, (char*)d, d.Size());

    }    
    cout << "\nOK.\n" << endl;    
  }


  /* ====================================================================== 
                                 Symbol Table
     ====================================================================== */
  
  if(!strlen(symtab_name)) {
    memset(send_buf, 0, sizeof(send_buf));
    sprintf(send_buf, "<SYMBOL_TABLE></SYMBOL_TABLE>");
    write(socket_descr, send_buf, strlen(send_buf));    
  }
  else {
    cout << "Sending symbol table contents from file \"" << symtab_name << "."; 
    cout.flush();

    DynamicString d;
    ifstream ifs(symtab_name);
    if(!ifs)
      cerr << "File \"" << symtab_name << "\" could not be opened !" << endl;
    else {
      d << "<SYMBOL_TABLE>";
      char c;
      
      while(!ifs.eof()) {
	ifs.get(c);
	if(ifs)
	  d << c;
      }

      d << "</SYMBOL_TABLE>";

      long len=d.Size(), n=0;
      char* tmp=(char*)d;
      for(long bytes_to_write=0; bytes_to_write < len; bytes_to_write+=n) {
	n=write(socket_descr, tmp+bytes_to_write, strlen(tmp)-bytes_to_write);
	
	//	write(2, tmp+bytes_to_write, strlen(tmp)-bytes_to_write);
	
      }


      //      write(socket_descr, (char*)d, d.Size());

    }    
    cout << "\nOK.\n" << endl;    
  }

  close(socket_descr);
  return 0;
}
