#ifndef SYMTAB_H
#define SYMTAB_H

#include "CL_List.h"
#include "DynamicString.h"
#include "global.h"

class Literal;
class NativeInstance;

enum SymType {normal_sym, native_sym};

void      ReadValue(istream&, DynamicString&);
Literal*  CreateLiteralFromString(char*);

extern char* agent_script;
extern char* agent_start_functions;
extern char* agent_symtab;


class Symbol {
protected:
  char*                _name;
  Literal*             _val;
public:
  SymType              _sym_type;
                       Symbol(char*, Literal* v=0);
  virtual              ~Symbol();
  char*                GetName() {return _name;}
  virtual Literal*     GetVal()  {return _val;}
  BType                GetValType();
  virtual void         SetVal(Literal& v);
  virtual void         Print(ostream& os=cout);
  virtual Symbol*      Copy();
  virtual Literal*     CopyVal();
  virtual void         Dump(ostream&);
};



class SymbolTable {
  CL_List<Symbol*>     _symbols;
  SymbolTable*         _prev_scope;  // parent- or 'enclosing-scope'
  void                 ReadTokens(istream&, CL_List<char*>&);
  void                 InsertValues(CL_List<char*>&);
public:
  
                       SymbolTable() {_prev_scope=0;}
  virtual              ~SymbolTable();
  void                 SetPrevScope(SymbolTable& prev_scope) {_prev_scope=&prev_scope;}
  SymbolTable*         GetPrevScope() {return _prev_scope;}
  CL_List<Symbol*>&    GetSymbols() {return _symbols;}
  virtual Symbol*      Lookup(char* name);  // finds, if not found --> creates and returns
  virtual Symbol*      Find(char* name);    // finds, if not found --> returns 0
  virtual void         Print(ostream& os=cout);
  virtual long         Size() {return _symbols.Size();}
  virtual Symbol*      operator[](int i) {return _symbols[i];}
  virtual SymbolTable& operator=(SymbolTable& other);
  virtual void         DeleteAll();
  virtual SymbolTable& Copy();
  virtual void         CopyTo(SymbolTable&);
  virtual void         Dump(ostream&);
  virtual void         Read(istream&);
};



class NativeSymbolTable : public SymbolTable {
protected:
  NativeInstance*      _this_ptr;
public:  
                       NativeSymbolTable(NativeInstance* inst_ptr) : _this_ptr(inst_ptr) {}
                       ~NativeSymbolTable() {}
  SymbolTable&         operator=(SymbolTable& other) {return SymbolTable::operator=(other);}
  Symbol*              Lookup(char* name);
  Symbol*              Find(char* name);
};



class NativeSymbol : public Symbol {
protected:
  NativeInstance*      this_ptr;
public:
                       NativeSymbol(char*, NativeInstance*, Literal* v=0);
                       ~NativeSymbol() {}
  Literal*             GetVal();
  void                 SetVal(Literal& v);
  NativeSymbol*        Copy();
};


#endif

