%{

#include <unistd.h>
#include "Grammar.h"
#include "Input.h"
#include "basic.yacc.tab.h"

extern SymbolTable symtab;



#define YY_INPUT(buf, result, max_size) {  \
    Input* inp=Input::GetInput(); \
    int c=(int)inp->GetChar(); \
    result=(c == 0)? YY_NULL : 1; \
    buf[0]=c; \
    buf[1]=0; \
}


#define YY_DECL int yylex YY_PROTO(( YYSTYPE* yylval))


%}


%%


"quit" |
"QUIT"     {return QUIT;}

"symbols"  {return SYMBOLS;}

"classes"  {return CLASSES;}

"inspect"  {return INSPECT;}

"reload"   {return RELOAD;}

"load"     {return LOAD;}

"define"   {return DEFINE;}

"return"   {return RETURN;}

"while"    {return WHILE;}

"if"       {return IF;}

"else"     {return ELSE;}

"for"      {return FOR;}

"to"       {return TO;}

"downto"   {return DOWNTO;}

"break"    {return BREAK;}

"dump"     {return DUMP;}

"read"     {return READ;}

"print"    {return PRINT;}

"println"  {return PRINTLN;}

"printcgi" {return PRINTCGI;}

"eval"     {return EVAL;}

"true" |
"TRUE"     {return TRUEVAL;}


"false" |
"FALSE"    {return FALSEVAL;}

"and"      {return AND;}

"or"       {return OR;}

"not"      {return NOT;}

"<"        {return LT;}
"<="       {return LTEQ;}
">"        {return GT;}
">="       {return GTEQ;}
"=="       {return EQ;}
"<>"  |
"!="       {return NOT_EQ;}

"mod" |
"%"        {return MOD;}

"class"    {return CLASS;}

"inherits" {return INHERITS;}

"from"     {return FROM;}

"vars"     {return VARS;}

"methods"  {return METHODS;}

"new"      {return NEW;}


"null"  |
"NULL"     {yylval->ex=new NilVal; return NONE;}


[0-9]*(\.[0-9]+)? {
        yylval->ex=new Int(atof((const char*)yytext));
	return NUMBER;
       }


\"     {
        DynamicString d;
	::ParseString(d);
	yylval->ex=new Str(d);
	return STRING;
       }


[ \t\n]  ;  /* skip whitespace */


[A-Za-z_][A-Za-z0-9_]*  {
        yylval->identifier=new Ident((char*)yytext);
	return IDENT;
       }


"/*"   {
        int c1=0, c2=0;
	c2=Input::GetInput()->GetChar();
	for(;;) {
	  if(c2 == EOF)
	    break;
	  if(c1 == '*' && c2 == '/')
	    break;
	  c1=c2;
	  c2=Input::GetInput()->GetChar();
	}
       }


\/\/.* ;   /* comment */

\#\!.*    ;   /* commment */

"$"    {return 0;}

\n     |
.      return yytext[0];


%%

#ifndef __linux__
extern "C" {
  int yywrap() {
    return 1;
  }
}
#endif
