%{
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "Grammar.h"
#include "BuiltinClasses.h"

short                 inside_class=0;
extern short          interactive;
extern short          prompt;

extern SymbolTable    symtab;
extern SymbolTable    classes;
extern int            yylineno;
extern unsigned char  yytext[];


void yyerror(char* msg) {
  printf("Error %s at '%s'\n", msg, yytext);
} 

static char buf[0xff];


%}


%union  {
  Expr*                ex;
  Symbol*              sym;
  Stmt*                st;
  Ident*               identifier;
  BoolExpr*            b_expr;
  Function*            fun;
  CL_List<Stmt*>*      bl;
  CL_List<Ident*>*     id_list;
  CL_List<Expr*>*      ex_list;
  CL_List<Function*>*  fun_list;
  int                  i;
  ClassDef*            cl_def;
}

%{

extern int yylex(YYSTYPE*);

%}


%pure_parser

%token               WHILE IF ELSE RELOAD FOR TO DOWNTO LOAD DUMP READ
%token               RETURN PRINT PRINTLN PRINTCGI DEFINE BREAK EVAL
%token               QUIT SYMBOLS TRUEVAL FALSEVAL MOD CLASSES INSPECT
%token               AND OR NOT
%token               LT LTEQ GT GTEQ EQ NOT_EQ
%token               VARS METHODS CLASS INHERITS FROM NEW
%token <identifier>  IDENT
%token <ex>          NUMBER STRING NONE
%left '-' '+'
%left '*' '/' MOD
%left AND OR
%nonassoc NOT
%nonassoc UMINUS

%type <ex>           expr, function_call, new_expr, list_expr;
%type <st>           stmt, print_stmt, return_stmt, if_stmt,
break_stmt, for_stmt, vars_stmt eval_stmt;
%type <identifier>   parm, opt_inherit_clause, ident;
%type <b_expr>       bool_expr, unary_bool_expr, bin_bool_expr, comp_expr;
%type <bl>           block, func_stmt_list, else_part;
%type <id_list>      parm_list, opt_vars_stmt;
%type <ex_list>      opt_arglist, arglist;
%type <fun>          function_def;
%type <cl_def>       class_def;
%type <fun_list>     methods, method_list;
%type <i>            up_or_down;


%%

stmt_list       :	stmt           {
			                if($1) {
					  $1->Interpret(::symtab); 
					  delete $1;
					  if(interactive) {
					    if(prompt) {
					      cout << "> ";
					      cout.flush();  
					    }
					    else
					      prompt=1;
                                          }
					} 
				       } 

		     |  stmt_list stmt {
			                if($2) {
					  $2->Interpret(::symtab); 
					  delete $2;
					  if(interactive) {
					    if(prompt) {
					      cout << "> "; 
					      cout.flush();
					    }
					    else
					      prompt=1;
					  }
					 }
				       } 
	             ; 


stmt		:	ident '=' expr ';' {$$=new Stmt($1, $3);}

	 	     |  expr ';'           {$$=new Stmt(0, $1);}

		     |  vars_stmt
		     
		     |  function_def   {
					Symbol* s=::symtab.Lookup($1->GetName());
					s->SetVal((Literal&)*$1);
					$$=0;
				       }

		     |  class_def      {
					Symbol* s=::classes.Lookup($1->GetName());
					s->SetVal((Literal&)*$1);
					cout << "#" << $1->GetName() << endl;
					$$=0;
				       }

	             |  error ';'      {$$=0; yyclearin; yyerrok;}

		     |  error QUIT     {$$=0; yyclearin; yyerrok;}

		     |  QUIT           {cout << "This is the end.\n" << endl;
					UnloadVBXs(); exit(1);}

		     |  SYMBOLS        {::symtab.Print(); $$=0;}

		     |  CLASSES        {::classes.Print(); $$=0;}

		     |  INSPECT expr ';' 
		        {
			 InspectInstance(*$2, ::symtab);
			 delete $2;
			 $$=0;
			}

		     |  reload_stmt    {$$=0;}

		     |  LOAD STRING ';'
		        {
			 LoadFile(((Str*)$2)->GetStr());
			 $$=0;
			}
		     
	             |  print_stmt

		     |  DUMP STRING ';' 
		        {
			 DumpSymbolTable(((Str*)$2)->GetStr()); 
			 $$=0;
		        }

		     |  DUMP ';' 
			{
			 DumpSymbolTable();
			 $$=0; 
			}

		     |  READ STRING ';' 
		        {
			 ReadSymbolTable(((Str*)$2)->GetStr());
			 $$=0;
		        }

		     |  READ ';' 
			{
			 ReadSymbolTable();
			 $$=0; 
		        }

                     |  WHILE '(' bool_expr ')'  '{' block '}'
			{
			 $$=new WhileStmt($3, $6);
			 delete $6;  /* cond is not copied, stmt_list is copied ! */
			}
		
		     |  if_stmt

 		     |  for_stmt 

		     |  return_stmt
		     
		     |  break_stmt 

		     |  eval_stmt

		     ;

ident           :       IDENT             {$$=$1;}
		     |	ident '.' IDENT   {$$->SetNext(*$3);}
		     ;

vars_stmt       :       VARS ':' parm_list ';' {$$=new VarsStmt(*$3); delete $3;}
		     ;

reload_stmt     :	RELOAD ident ';'    {ReloadVBXs($2->GetName()); delete $2;}
		     |	RELOAD       ';'    {ReloadVBXs();}
		     ;

for_stmt        :	FOR '(' ident '=' expr up_or_down expr ')' '{' block '}'
			{
			 ForStmt* s=new ForStmt(*$3, *$5, $6, *$7, $10);
			 delete $10;  // is copied into ForStmt
			 $$=s;
			}
		     ;

up_or_down      :       TO     {$$=0;}
		     |  DOWNTO {$$=1;}
		     ;

break_stmt      :       BREAK ';' {$$=new BreakStmt();} ;

if_stmt         :       IF '(' bool_expr ')' '{' block '}' else_part
		        {
			 $$=new IfStmt($3, $6, $8); delete $6; delete $8;
			}
		     ;

else_part	:       ELSE '{' block '}' {$$=$3;}
		     |  /* empty */        {$$=0;}
		     ;



block		:       stmt         {$$=new CL_List<Stmt*>; 
				      if($1) $$->Add($1, ::tail);}
		     |	block stmt   {if($2) $$->Add($2, ::tail);}
		     ;

function_def    :       DEFINE ident  '(' parm_list ')' '{' func_stmt_list '}'
				     {
				      if(inside_class)
				        $$=new Method($2->GetName(), $4, $7);
				      else
				        $$=new Function($2->GetName(), $4, $7);
				      if($4) {
				        DOP($4, Ident*, item)
				          delete item;
				        ODP
				        delete $4;
				      }
				      delete $2;  // Ident is not used any more
		                     }
	                 ;



parm_list	:       parm                {$$=new CL_List<Ident*>;
					     if($1) $$->Add($1, ::tail);}
		     |  parm_list ',' parm  {if($3) $$->Add($3, ::tail);}
		     |  /* empty */         {$$=new CL_List<Ident*>;}
		     ;

parm		:       ident;


func_stmt_list  :	stmt                {$$=new CL_List<Stmt*>;
					     if($1) $$->Add($1, ::tail);}
		     |  func_stmt_list stmt {if($2) $$->Add($2, ::tail);}
		     ;



return_stmt     :       RETURN expr ';'          {$$=new ReturnStmt($2);}
		     |  RETURN      ';'          {$$=new ReturnStmt();}

print_stmt      :       PRINT    expr ';'        {$$=new PrintStmt($2);};
		     |	PRINTLN  expr ';'        {$$=new PrintStmt($2, 1);}
		     |  PRINTLN       ';'        {$$=new PrintStmt(0, 1);}
		     |	PRINTCGI expr ';'        {$$=new PrintStmt($2, 0, 1);}
		     ;

eval_stmt       :       EVAL expr ';'            {$$=new EvalStmt($2);}

expr		:	expr '+' expr            {$$=new BinExpr($1, op_plus, $3);}

		     |  expr '-' expr            {$$=new BinExpr($1, op_minus, $3);}

		     |  expr '*' expr            {$$=new BinExpr($1, op_mult, $3);}

		     |  expr '/' expr            {$$=new BinExpr($1, op_div, $3);}
		     
		     |  expr MOD expr	         {$$=new BinExpr($1, op_mod, $3);}

		     |  '-' expr %prec UMINUS    {$$=new UnaryExpr(op_minus, $2);}

  		     |  '(' expr ')'             {$$=$2;}

		     |  ident                    {$$=$1;}

		     |  NUMBER                   {$$=$1;}

		     |  STRING                   {$$=$1;}
		     
		     |  NONE                     {$$=$1;}

		     |  list_expr

		     |  function_call            {$$=$1;}
		     
		     |  new_expr
		     ;

list_expr       :	'#' '(' opt_arglist ')' 
		        {
			 $$=new CreationExpr("List", $3);
			}


new_expr        :       NEW IDENT  {$$=new CreationExpr($2->GetName());
				    delete $2;}

		     |	NEW IDENT '(' opt_arglist ')'
			{
			 $$=new CreationExpr($2->GetName(), $4);
			 delete $2;
			}
		     ;


function_call   :       ident '(' opt_arglist ')' 
			{
			 if(inside_class || $1->GetNext()) {
			   $$=new MethodCall(*$1, $3); 
			   delete $3;
			 }
			 else {
			   $$=new FunctionCall(*$1, $3); 
			   delete $3;
			 }  
			} 
		     ;


opt_arglist     :       arglist              {$$=$1;}
		     |  /* empty */	     {$$=0;}
		     ;

arglist         :       expr                 {$$=new CL_List<Expr*>; 
					       if($1) $$->Add($1, ::tail);
					     }

		     |  arglist ',' expr     {if($3) $$->Add($3, ::tail);}
		     ;


bool_expr       :       TRUEVAL              {$$=new BoolExpr(new gomBool(1));}
		     |  FALSEVAL             {$$=new BoolExpr(new gomBool(0));}
		     |  '(' bool_expr ')'    {$$=$2;}
		     |  unary_bool_expr      {$$=$1;}
		     |  bin_bool_expr        {$$=$1;}
		     |  comp_expr            {$$=$1;}
		     ;

comp_expr       :	expr LT      expr    {$$=new CompBoolExpr($1, lt,     $3);}
		     |	expr LTEQ    expr    {$$=new CompBoolExpr($1, lteq,   $3);}
		     |  expr GT      expr    {$$=new CompBoolExpr($1, gt,     $3);}
		     |  expr GTEQ    expr    {$$=new CompBoolExpr($1, gteq,   $3);}
		     |  expr EQ      expr    {$$=new CompBoolExpr($1, eq,     $3);}
		     |  expr NOT_EQ  expr    {$$=new CompBoolExpr($1, not_eq, $3);}
		     ;


unary_bool_expr :	NOT bool_expr %prec NOT  {$$=new UnaryBoolExpr($2);}
		     ;


bin_bool_expr   :	bool_expr  AND bool_expr  {$$=new BinBoolExpr($1, and_op ,$3);}
		     |  bool_expr  OR  bool_expr  {$$=new BinBoolExpr($1, or_op ,$3);}
		     ;
		   
/* -------------------------------------------------------------------- */
/*                      Object-Oriented Extensions                      */
/* -------------------------------------------------------------------- */

class_def       :       CLASS {inside_class=1;}
			ident opt_inherit_clause '{' opt_vars_stmt methods '}' 
		        {
			 $$=new ClassDef($3->GetName(), $4, $6, $7);
			 delete $3;
			 inside_class=0;          /* end class definition   */
			}
		     ;

opt_inherit_clause :    INHERITS FROM ident {$$=$3;}
		     |  /* empty */         {$$=0;}
		     ;

opt_vars_stmt   :	VARS ':' parm_list ';' {$$=$3;}
		     |  /* empty */            {$$=0;}
		     ;


methods         :       METHODS ':' method_list {$$=$3;}
		     |  /* empty */             {$$=0;}
		     ;

method_list     :       function_def              {$$=new CL_List<Function*>; $$->Add($1);}
		     |  method_list function_def  {$$->Add($2);}
		     ;


%%


