#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#ifdef _AIX
  #include <sys/select.h>
  #include <strings.h>
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>


void Credentials() {
  printf("\n          ----------------------------------------------------------\n"   );
  printf("             Client front end to GOMscript-interpreter written by \n"  );
  printf("                                 Bela Ban\n"                           );
  printf("                       IBM Zurich Research Laboratory\n"               );
  printf("                              bba@zurich.ibm.com\n"                    );
  printf("                                  Version 0.7\n"                       );
  printf("                       Built on %s at %s\n",	__DATE__, __TIME__       );
  printf("          ----------------------------------------------------------\n\n\n" );  
}


/* Sends a UDP packet to the server */
short SendUsageToServer(char* progname, char* msg, int port_number) {
  int                 socket_descr, rc;
  struct sockaddr_in  server_addr, client_addr;
  char                buffer[0xff];
  char*               host_name="9.4.21.181";  /* adlerhorn@zurich.ibm.com */
  time_t              tim;
  char*               time_as_str="<unknown time>";
  char                userid[32], user_host[128], *ret;

  socket_descr=socket(AF_INET, SOCK_DGRAM, 0);
  if(socket_descr == -1)
    return 0;

  bzero((char*)&server_addr, sizeof(server_addr));
  server_addr.sin_family=AF_INET;
  server_addr.sin_addr.s_addr=inet_addr(host_name);
  server_addr.sin_port=htons(port_number);
  #ifndef __linux__
  server_addr.sin_len=sizeof(server_addr);
  #endif

  /* Now get a port for the client to send messages to the server: */
  /* Setting the port to 0 assigns a unique client port            */

  bzero((char*)&client_addr, sizeof(client_addr));
  client_addr.sin_family=AF_INET;
  client_addr.sin_addr.s_addr=htonl(INADDR_ANY);
  client_addr.sin_port=htons(0);
  #ifndef __linux__
  client_addr.sin_len=sizeof(client_addr);
  #endif

  rc=bind(socket_descr, (struct sockaddr*)&client_addr, sizeof(client_addr));
  if(rc == -1) {
    close(socket_descr);
    return 0;
  }

  time(&tim);

  time_as_str=ctime(&tim);    

  /* fill in buffer */
  if(msg)
    sprintf(buffer, "%s: %s, %s", progname, msg, time_as_str);
  else {
    ret=cuserid(userid);
    if(!ret)
      strcpy(userid, "<unknown>");    
    rc=gethostname(user_host, sizeof(user_host));
    if(rc == -1)
      strcpy(user_host, "<unknown host>");    
    sprintf(buffer, "%s: %s, %s, %s", progname, userid, user_host, time_as_str);
  }

  rc=sendto(socket_descr, buffer, sizeof(buffer), 0, 
	    (struct sockaddr*)&server_addr, sizeof(struct sockaddr_in));
  if(rc < 0) {
    close(socket_descr);
    return 0;
  }
  close(socket_descr);
  return 1;
}


int main(int argc, char* argv[]) {
  int                 socket_descr, rc;
  struct sockaddr_in  addr, from;  /* Internet type of socket address is used */
  int                 from_len, bytes;
  char                buffer[0xff];
  char*               host_name="9.4.21.181"; /* adlerhorn@zurich.ibm.com */
  int                 port_number=10000;
  struct hostent*     h_ent;
  static char         receive_buf[0xffff];
  fd_set              fd;

  if(argc > 1 && !strncmp(argv[1], "-h", 2)) {
    printf("Usage: \"client\" [<hostname>] [<port>]\n");
    printf("(e.g.: IP-Address = \"adlerhorn@zurich.ibm.com\", Port-Number = 10000\n");
    return -1;
  }

  switch(argc) {
  case 2:
    host_name=argv[1];
    break;
  case 3:
    host_name=argv[1];
    port_number=atoi(argv[2]);
    break;
  }

  h_ent=gethostbyname(host_name);
  if(!h_ent) {
    printf("%s is not a known host !\n", host_name);
    return -1;
  }

  printf("Interpreter client started.\n");
  printf("Connected to host %s at port %li\n", host_name, port_number);
  socket_descr=socket(AF_INET, SOCK_STREAM, 0);
  if(socket_descr == -1) {
    printf("Socket could not be created !\n");
    return -1;
  }

  bzero((char*)&addr, sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_addr.s_addr=((struct in_addr*)h_ent->h_addr_list[0])->s_addr;
  addr.sin_port=htons(port_number);
  #ifndef __linux__
  addr.sin_len=sizeof(addr);
  #endif
  rc=connect(socket_descr, (struct sockaddr*)&addr, sizeof(addr));
  if(rc) {
    perror("Interpreter client");
    return rc;
  }

  Credentials();
  SendUsageToServer("Client", 0, 1717);
  printf("Connection to server established.\n\n");
  printf("Ready to accept statements:\n");

  for(;;) {
    FD_ZERO(&fd);
    FD_SET(0, &fd);              /* stdin */
    FD_SET(socket_descr, &fd);   /* server socket */
    
    rc=select(socket_descr+1, &fd, 0, 0, 0);
    memset(receive_buf, 0, sizeof(receive_buf));   
    if(FD_ISSET(0, &fd)) {
      bytes=read(0, receive_buf, sizeof(receive_buf));
      if(!strcmp(receive_buf, "quit\n"))
	break;
      bytes=write(socket_descr, (char*)receive_buf, strlen(receive_buf));
    }
    else if(FD_ISSET(socket_descr, &fd)) {
      bytes=read(socket_descr, receive_buf, sizeof(receive_buf));
      printf("%s", receive_buf);
    }
    fflush(0);
  }
  printf("Done sending data to host.\n");
  close(socket_descr);
  return 0;
}
