

define CreateCMIPObj(host) {
  vars: cmip_obj;
  cmip_obj=new Obj("", "::Liaison::DSOMCMIPObj", host);
  cmip_obj.SetAgentAET("MIBCTL");
  cmip_obj.SetObjectClass("opNetwork");
  cmip_obj.SetObjectInstance("genericNetworkId=TelcoNet@customerID=(name IBM)@networkId=(pString LucaNetwork_96)");
  cmip_obj.SetAttribute("networkTitle", "(nothing NULL)");

  cmip_obj.CMIPCreateObject();
  return cmip_obj;
}

define SetCMIPObj() {
  vars: cmip_obj;
  cmip_obj=new Obj("", "::Liaison::DSOMCMIPObj", "");
  cmip_obj.SetAgentAET("MIBCTL");
  cmip_obj.SetObjectInstance("genericNetworkId=TelcoNet@customerID=(name IBM)@networkId=(pString Europe)");
  cmip_obj.SetAttribute("networkTitle", "(oid 1.2.3.4.5)");

  cmip_obj.CMIPSetAttributes();
  return cmip_obj;
}

define CreateSNMPObj(host, port) {
  snmp_obj=new Obj("", "::Liaison::DSOMSNMPObj", "");
  if(snmp_obj != null) {
    snmp_obj.SetSnmpAgentAddress(host, port);
  }
  return snmp_obj;  
}

define Stress(number) {
  vars: obj, list;
  list=#();
  for(i=0 to number) {
    obj=CreateCMIPObj("genericNetworkId=TelcoNet@customerID=(name IBM)");
    list.Add(obj);
  }
  for(i=0 to list.Length()-1) {
    print i;
    print ": ";
    obj=list.At(i);
    ShowVars(obj);
  }
}

define CreateNewObj() {
  vars: a;
  a=CreateCMIPObj("genericNetworkId=TelcoNet@customerID=(name IBM)@networkId=(pString eNorth_America)", "");
  return a;
}

///////////////////////////////////////////////////////////////////////////////////////////////

define show(keys, vals) {
  vars: current_key, current_val;
  for(i=0 to keys.Length()-1) {
    current_key=keys.At(i);
    current_val=vals.At(i);
    println "Key: " + current_key + ", Value " + current_val;
  }
}


define ShowVars(obj) {
  vars: keys, vals;
  keys=obj.GetAttributeKeys();
  vals=obj.GetAttributes();
  show(keys, vals);
}


