

class SNMPObj {
  vars: obj;

  methods:
    
    define SNMPObj(hostname) {
      obj=new Obj("", "::Liaison::DSOMSNMPObj", "");
      if(obj == NULL) {
	println "Object ::Liaison::DSOMSNMPObj could not be created !";
	return;
      }
      host=hostname;
      obj.SetSnmpAgentAddress(hostname, 160);
    }

    define Get(attrname) {
      if(obj == NULL) {
        println "Instance variable obj is NULL !";
	return NULL;
      }
      obj.SetAttribute(attrname, "");
      err=GetEx();
      if(err != NULL) {
	println "SetAttribute failed !";
	println "Err: '" + err + "'";
	ResetEx();
	return NULL;
      }
      obj.SNMPGetAttribute();
      err=GetEx();
      if(err != NULL) {
	println "Exception occurred: " + err;
	ResetEx();
	return NULL;
      }
      ret=obj.GetAttribute(attrname);
      return ret;
    }


    define Walk() {
      if(obj == NULL) {
	println "obj is NULL";
	return;
      }
      println "Getting all attributes of the entire MIB. This may take some time !";
      l=obj.SNMPWalk();
      if(l == NULL) {
	println "SNMPWalk returned an empty list !";
	return;
      }
      println "Length of list is: " + l.Length();
      for(i=0 to l.Length()-1) {
        current_obj=l.At(i);
	if(current_obj <> NULL) {
	  keys=current_obj.GetAttributeKeys();
	  vals=current_obj.GetAttributes();
	  print "KEY: ";
	  println keys.At(0);
	  print "VAL: ";
	  println vals.At(0);
	  println "-------------------------------------------------------";
	  Sleep(0.1);
	}
      }
      obj.RemoveAllAttributes();
    }



}
