
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <strings.h>
#include <iostream.h>
#include <fstream.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>

#ifdef _AIX
#include <sys/select.h>
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#include <strstream.h>
#include "defs.h"
#include "DynamicString.h"

extern SymbolTable symtab;


/* ---------------------------------------------------------------------------
   Function prototypes
   --------------------------------------------------------------------------- */
Expr* SendAgent(Elist& arglist); 
                         // host       port     initial funs script name
BType SendAgent_types[]={STRING_TYPE, INT_TYPE, STRING_TYPE, STRING_TYPE};


/* ---------------------------------------------------------------------------
   Function list and entry point
   --------------------------------------------------------------------------- */

static FuncDescr functions[]={
  /* name            address      num of parms   parm types                    */
  /* --------        ---------    ------------   ----------                    */

  {"SendAgent",      SendAgent,        4,        SendAgent_types},
  0
};

static Contents contents={functions, 0, 0, 0};

Contents* EntryPoint() {
  return &contents;
}




/* ---------------------------------------------------------------------------
   Function implementations
   --------------------------------------------------------------------------- */


Expr* SendAgent(Elist& arglist) {
  long                len=0, n=0;
  char*               hostname=((Str*)arglist[0])->GetStr();
  int                 port=(int)((Int*)arglist[1])->GetInt();
  char*               initial_functions=((Str*)arglist[2])->GetStr();
  char*               script_name=((Str*)arglist[3])->GetStr();
  gomBool*            ret=new gomBool(1);
  int                 socket_descr, rc;
  struct sockaddr_in  addr;  /* Internet type of socket address is used */
  struct hostent*     h_ent;

  if(!hostname || !strlen(hostname))
    hostname="localhost";
  if(!port)
    port=10000;
  if(!initial_functions)
    initial_functions="";
  if(!script_name || !strlen(script_name))
    script_name=0;

  h_ent=gethostbyname(hostname);
  if(!h_ent) {
    perror("");
    ret->SetFalse();
    return ret;
  }
  
  socket_descr=socket(AF_INET, SOCK_STREAM, 0);
  if(socket_descr == -1) {
    perror(0);
    ret->SetFalse();
    return ret;
  }

  bzero((char*)&addr, sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_addr.s_addr=((struct in_addr*)h_ent->h_addr_list[0])->s_addr;
  addr.sin_port=htons(port);

  #ifndef __linux__
  addr.sin_len=sizeof(addr);
  #endif


  rc=connect(socket_descr, (struct sockaddr*)&addr, sizeof(addr));
  if(rc) {
    perror("");
    ret->SetFalse();
    return ret;
  }


  DynamicString d;
  
  d << "<SCRIPT>\n";
  if(::agent_script)
    d << ::agent_script;
  d << "\n</SCRIPT>\n";

  d << "<INITIAL_FUNCTIONS>\n";
  if(::agent_start_functions)
    d << ::agent_start_functions;
  else if(!::agent_script)  // if start script *and* initial functions are empty
    d << "println \"/* Empty script */\";";
  if(initial_functions)
    d << initial_functions;

  if(script_name) {
    ifstream   ifs(script_name);
    ostrstream ostr((char*)0, 0xff);
    while(ifs)
      ostr << (char)ifs.get();
    
    if(ostr.str() && strlen(ostr.str()))
      d << "\n" << ostr.str() << "\n";
  }

  d << "\n</INITIAL_FUNCTIONS>\n";

  d << "<SYMBOL_TABLE>\n";
  if(::symtab.Size()) {
    ostrstream ostr((char*)0, 0xff);
    ::symtab.Dump(ostr);
    d << ostr.str();
  }
  d << "\n</SYMBOL_TABLE>";

  len=d.Size(), n=0;
  char* tmp=(char*)d;
  for(long bytes_to_write=0; bytes_to_write < len; bytes_to_write+=n)
    n=write(socket_descr, tmp+bytes_to_write, strlen(tmp)-bytes_to_write);

  close(socket_descr);
  return ret;
}


