
#include <math.h>
#include <unistd.h>
#include "defs.h"
#include "valueAccess.h"


/* ---------------------------------------------------------------------------
   Function prototypes
   --------------------------------------------------------------------------- */
Expr* Execute(Elist& arglist); BType Execute_types[]={STRING_TYPE};
Expr* Sleep(Elist& arglist);   BType Sleep_types[]={INT_TYPE};
Expr* Trim(Elist& arglist);    BType Trim_types[]={STRING_TYPE};


/* ---------------------------------------------------------------------------
   Function list and entry point
   --------------------------------------------------------------------------- */

static FuncDescr functions[]={
  /* name            address      num of parms   parm types                    */
  /* --------        ---------    ------------   ----------                    */

  {"exec",           Execute,          1,        Execute_types},
  {"Sleep",          Sleep,            1,        0            },
  {"Trim",           Trim,             1,        Trim_types   },
  0
};

static Contents contents={functions, 0, 0, 0};

Contents* EntryPoint() {
  return &contents;
}




/* ---------------------------------------------------------------------------
   Function implementations
   --------------------------------------------------------------------------- */


Expr* Execute(Elist& arglist) {
  valueAccess val;
  Expr*       ex=arglist[0];
  if(ex->type != STRING_TYPE) {
    cerr << "Argument to exec must be string !" << endl;
    return 0;
  }
  char*       s=((Str*)ex)->GetStr();
  val.doCall(s);
  char*       ret=val.getBuf();
  return new Str(ret); 
}


Expr* Sleep(Elist& arglist) {
  int l=(int)((Int*)arglist[0])->GetInt();
  sleep(l);
  return 0;
}


/* Remove junk on both sides of a string, return copy */
Expr* Trim(Elist& arglist) {
  Str*   ret=0;
  char*  tmp=((Str*)arglist[0])->GetStr();
  char*  tmp2=0;
  if(!tmp) return 0;
  int i=0;
  char* buf=new char[strlen(tmp)+1];
  tmp2=tmp;
  while(*tmp2) {
    switch(*tmp2) {
    case ' ':
    case '\n':
    case '\t':
      tmp2++;
      continue;
    default:
      buf[i]=*tmp2++;
      i++;
    }
  }
  buf[i]=0;
  ret=new Str(buf);
  delete [] buf;
  return ret;
}
