

#include "defs.h"

typedef Expr* (NativeInstance::* MethPtr)(Elist&);

class Luca : public NativeInstance {
  char*      _name;
  int        _age;
protected:
             Luca(char*, int);
public:
             Luca(Elist& args);  // char* name, int age
             ~Luca();
  Luca*      Copy();
  void       Print(ostream& os=cout);
  void       Inspect(ostream& os=cout);
  Literal*   GetVal(char*);
  void       SetVal(char*, Literal& v);
  Symbol*    Lookup(char* name);
  Symbol*    Find(char* name);  

  Expr*      Ctor(Elist&    args);
  Expr*      GetName(Elist& args);
  Expr*      GetAge(Elist&  args);
  Expr*      SetName(Elist& args);
  Expr*      SetAge(Elist&  args);
  Expr*      Show(Elist&    args);
};

NativeInstance* MakeLuca(Elist& args) {
  return new Luca(args);
}


MethodDescr Luca_methods[]={
  {"GetName", (MethPtr)&Luca::GetName, 0, 0},
  "GetAge",  (MethPtr)&Luca::GetAge,  0, 0,
  "SetName", (MethPtr)&Luca::SetName, 1, 0,
  "SetAge",  (MethPtr)&Luca::SetAge,  1, 0,
  "Show",    (MethPtr)&Luca::Show,    0, 0,
  0
};

ClassDescr classes[]={
  {"Luca", 0, MakeLuca, 
   Luca_methods
  }, 
  0
  };

Contents contents={0, classes, 0, 0};

Contents* EntryPoint() {return &contents;}



/* ---------------------------------------------------------------------------
                                 Implementation
   --------------------------------------------------------------------------- */

Luca::Luca(char* name, int age) : NativeInstance("Luca"), _name(0), _age(age) {
  if(name)
    _name=strdup(name);
}

Luca::Luca(Elist& args) : NativeInstance("Luca"), _name(0), _age(0) {
  Str*  name=(Str*)args[0];
  Int* age=(Int*)args[1];
  if(!name || !age) return;
  _name=strdup(name->GetStr());
  _age=age->GetInt();
}


Luca::~Luca() {
  delete [] _name;
}


Luca* Luca::Copy() {
  return new Luca(_name, _age);
}


void Luca::Print(ostream& os) {
  os << "Name: "; if(_name) os << _name; os << endl;
  os << "Age:  "; os << _age << endl;
}


void Luca::Inspect(ostream& os) {
  Print(os);
  os << "\nMethods:\n--------:\n";
  PrintMethods(os);
  os << endl;
}


Literal* Luca::GetVal(char* name) {
  if(!strcmp(name, "_name"))
    return _name? new Str(_name) : 0;
  if(!strcmp(name, "_age"))
    return new Int(_age);
  return 0;
}


void Luca::SetVal(char* name, Literal& v) {
  if(!strcmp(name, "_name") && v.type == STRING_TYPE) {
    delete [] _name;
    _name=strdup(((Str&)v).GetStr());
    return;
  }
  if(!strcmp(name, "_age") && v.type == INT_TYPE)
    _age=((Int&)v).GetInt();
}


Symbol* Luca::Lookup(char* name) {
  Literal* l=GetVal(name);
  if(l)
    return new NativeSymbol(name, this, l);
  return 0;
}

Symbol* Luca::Find(char* name) {
  return Lookup(name);
}


Expr* Luca::GetName(Elist& args) {
  return _name? new Str(_name) : 0;
}

Expr* Luca::GetAge(Elist& args) {
  return new Int(_age);
}

Expr* Luca::SetName(Elist& args) {
  Str* name=(Str*)args[0];
  if(name) {
    delete [] _name;
    _name=strdup(name->GetStr());
  }
  return 0;
}

Expr* Luca::SetAge(Elist& args) {
  Int* i=(Int*)args[0];
  if(i)
    _age=i->GetInt();
  return 0;
}

Expr* Luca::Show(Elist& args) {
  cout << "Name: "; if(_name) cout << _name << endl;
  cout << "Age:  " << _age << endl;
  return 0;
}

