
#include <math.h>
#include "defs.h"

/* ---------------------------------------------------------------------------
   Function prototypes
   --------------------------------------------------------------------------- */
Expr* Fibonacci(Elist& arglist); BType Fibonacci_types[]={INT_TYPE};
Expr* Exp(Elist& arglist); BType Exp_types[]={INT_TYPE};
Expr* Add(Elist& arglist); BType Add_types[]={INT_TYPE, INT_TYPE};
Expr* VerboseFibonacci(Elist& arglist); BType VerboseFibonacci_types[]={INT_TYPE};
Expr* Print(Elist& arglist);
Expr* Println(Elist& arglist);
Expr* StrLength(Elist& arglist); BType strlen_types[]={STRING_TYPE};
Expr* Mult(Elist& arglist); BType Mult_types[]={INT_TYPE, INT_TYPE};



/* ---------------------------------------------------------------------------
   Function list and entry point
   --------------------------------------------------------------------------- */

static FuncDescr functions[]={
  /* name               address           num of parms   parm types                    */
  /* --------           ---------         ------------   ----------                    */
  {"Fibonacci",         Fibonacci,          1,           Fibonacci_types},
  {"Exp",               Exp,                1,           Exp_types},
  {"Add",               Add,                2,           Add_types}, 
  {"VerboseFibonacci",  VerboseFibonacci,   1,           VerboseFibonacci_types}, 
  {"Print",             Print,              1,           0},
  {"Println",           Println,            1,           0},
  {"strlen",            StrLength,          1,           strlen_types},
  {"Mult",              Mult,               2,           Mult_types},
  0
};

static Contents contents={functions, 0, 0, 0};

Contents* EntryPoint() {
  return &contents;
}




/* ---------------------------------------------------------------------------
   Function implementations
   --------------------------------------------------------------------------- */
long fib(long x) {
  if(x == 1 || x == 2)
    return 1;
  else
    return fib(x-1)+fib(x-2);
}

Expr* Fibonacci(CL_List<Expr*>& arglist) {
  Expr* ex=arglist.GetFirst()->GetElement();
  if(ex->type != INT_TYPE) {
    cerr << "Argument to Fibonacci was not integer !" << endl;
    return 0;
  }
  long x=(long)((Int*)ex)->GetInt();
  return new Int(fib(x));
}


Expr* Exp(CL_List<Expr*>& args) {
  Expr* ex=args.GetFirst()->GetElement();
  if(ex->type != INT_TYPE) {
    cerr << "Argument to Abs was not integer !" << endl;
    return 0;
  }
  long inp=((Int*)ex)->GetInt();
  long res=exp(inp);
  return new Int(res);
}

Expr* Add(CL_List<Expr*>& arglist) {
  Expr* a=arglist[0], *b=arglist[1];
  if(a->type != INT_TYPE || b->type != INT_TYPE) {
    cerr << "One or both of the args to Add is not integer !" << endl;
    return 0;
  }
  long res=((Int*)a)->GetInt()+((Int*)b)->GetInt();
  return new Int(res);
}

long vfib(long x) {
  cout << x << endl;
  if(x == 1 || x == 2)
    return 1;
  else
    return vfib(x-1)+vfib(x-2);
}

Expr* VerboseFibonacci(CL_List<Expr*>& arglist) {
  Expr* ex=arglist.GetFirst()->GetElement();
  if(ex->type != INT_TYPE) {
    cerr << "Argument to VerboseFibonacci was not integer !" << endl;
    return 0;
  }
  long x=(long)((Int*)ex)->GetInt();
  return new Int(vfib(x));
}

Expr* Print(Elist& arglist) {
  Expr* ex=arglist[0];
  ex->Print(cout);
  return 0;
}

Expr* Println(Elist& arglist) {
  Print(arglist);
  cout << endl;
  return 0;
}


Expr* StrLength(Elist& arglist) {
  Expr* ex=arglist[0];
  if(ex->type != STRING_TYPE) {
    cerr << "Argument to strlen is not a string !" << endl;
    return 0;
  }
  return new Int(strlen(((Str*)ex)->GetStr()));
}


Expr* Mult(Elist& arglist) {
  Expr* a=arglist[0], *b=arglist[1];
  if(a->type != INT_TYPE || b->type != INT_TYPE) {
    cerr << "One or both args to Mult not integer" <<  endl;
    return 0;
  }
  long res=((Int*)a)->GetInt() * ((Int*)b)->GetInt();
  return new Int(res);
}
