
#include "Socket.h"


/* ---------------------------------------------------------------------------
   Function prototypes
   --------------------------------------------------------------------------- */


/* ---------------------------------------------------------------------------
   Function list and entry point
   --------------------------------------------------------------------------- */

static FuncDescr functions[]={
  /* name               address      num of parms    parm types                */
  /* --------           ---------    ------------    ----------                */
    0
};





typedef Expr* (NativeInstance::* MethPtr)(Elist&);


class ServerSocket : public Socket {  
    int            _server_sock;
public:
                   ServerSocket(int sockfd, int server_sock=-1);
                   ServerSocket(Elist& args);  // port
                   ~ServerSocket();
    short          IsValid() {return _server_sock < 0 ? 0 : 1;}
    ServerSocket*  Copy();
    void           Print(ostream& os=cout);
    void           Inspect(ostream& os=cout);
    
    Expr*          Accept(Elist& args);
    Expr*          CloseServerConnection(Elist& args);
};




NativeInstance* MakeServerSocket(Elist& args) {
    ServerSocket* retval=new ServerSocket(args);
    return retval->IsValid() ? retval : 0;
}



MethodDescr ServerSocket_methods[]={
    {"Accept", (MethPtr)&ServerSocket::Accept, 0, 0},
    {"CloseServerConnection", (MethPtr)&ServerSocket::CloseServerConnection, 0, 0},
    0
};




static ClassDescr classes[]={
  {"ServerSocket", "Socket", MakeServerSocket, ServerSocket_methods}, 
  0
  };


void ServerSocketLoadFunction()   {}

void ServerSocketUnLoadFunction() {}


static Contents contents={0, (ClassDescr*)classes, 
			  ServerSocketLoadFunction, ServerSocketUnLoadFunction};

Contents* EntryPoint() {return &contents;}



/* ---------------------------------------------------------------------------
                                 Implementation
   --------------------------------------------------------------------------- */

ServerSocket::ServerSocket(int sockfd, int server_sock) 
    : Socket(sockfd), _server_sock(server_sock) {
}





/* Arguments: hostname and socket */
ServerSocket::ServerSocket(Elist& args) : Socket(-1) {
  int                 numargs=args.Size();
  long                len=0;
  int                 port=(int)((Int*)args[0])->GetInt();
  int                 rc;
  struct sockaddr_in  addr;
  struct hostent*     h_ent;

  if(_metaclass)
      delete [] _metaclass;
  _metaclass=strdup("ServerSocket");
  
  if(numargs != 1) {
      cerr << "Wrong number of arguments to ServerSocket(port) !" << endl;
      return;
  }  

  _server_sock=socket(AF_INET, SOCK_STREAM, 0);
  if(_server_sock == -1) {
    perror(0);
    return;
  }

  bzero((char*)&addr, sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_addr.s_addr=inet_addr(INADDR_ANY);
  addr.sin_port=htons(port);
  rc=bind(_server_sock, (sockaddr*)&addr, sizeof(addr));
  if(rc) {
      perror(0);
      close(_server_sock);
      _server_sock=-1;
      return;
  }
  
  rc=listen(_server_sock, 5);  // 5 is max. queue length
  if(rc < 0) {
      perror(0);
      close(_server_sock);
      _server_sock=-1;
      return;
  }

}


ServerSocket::~ServerSocket() {
  
}


ServerSocket* ServerSocket::Copy() {
  return new ServerSocket(_sockfd, _server_sock);
}



void ServerSocket::Print(ostream& os) {
    os << "<Instance of ServerSocket ";
    if(IsValid())
	os << "(opened)";
    else
	os << "(closed)";
    os << ">";
}


void ServerSocket::Inspect(ostream& os) {
  Print(os);
  os << "Methods:\n-----------\n\n";
  os << "Write(string): writes the string to the socket, returns number"
      " of bytes written" << endl;
  os << "ServerSocket(hostname, port): Constructor, takes hostname (string) and "
      "port (number)" << endl;
  os << "Read(): returns the token that was read or NULL" << endl;
  os << "Close(): closes the socket" << endl;
  os << endl;
}



Expr* ServerSocket::Accept(Elist& args) {
    size_t               from_len=0;
    struct sockaddr_in   from;
    if(_server_sock == -1) {
	cerr << "Socket is not opened !" << endl;
	return 0;
    }

  _sockfd=accept(_server_sock, (sockaddr*)&from, &from_len);
  if(_sockfd < 0)
      perror(0);
  return 0;
}



Expr* ServerSocket::CloseServerConnection(Elist& args) {
    if(_server_sock == -1) {
	close(_server_sock);
	_server_sock=-1;
    }
    return 0;
}
