
#ifndef SOCKET_H
#define SOCKET_H


#include "defs.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#include <fcntl.h>
#ifdef _AIX
#include <strings.h>
#endif


class Socket : public NativeInstance {  
protected:
    int            _sockfd;
public:
                   Socket(int sockfd);
                   Socket(Elist& args);  // classname args
                   ~Socket();
    virtual short  IsValid() {return _sockfd < 0 ? 0 : 1;}
    Socket*        Copy();
    void           Print(ostream& os=cout);
    void           Inspect(ostream& os=cout);
    void           Dump(ostream&);
    void           Read(istream&);
    Symbol*        Lookup(char* name)       {return 0;}
    Symbol*        Find(char* name)         {return 0;}
    

    Expr*          Write(Elist&             args);
    Expr*          ReadToken(Elist&         args);
    Expr*          Close(Elist&             args);
};


#endif

