
/* ---------------------------------------------------------------------------
                                 Implementation
   --------------------------------------------------------------------------- */

#include "Socket.h"

Socket::Socket(int sockfd) : NativeInstance("Socket"), _sockfd(sockfd) {
}





/* Arguments: hostname and socket */
Socket::Socket(Elist& args) : NativeInstance("Socket"), _sockfd(-1) {
  int                 numargs=args.Size();
  long                len=0;
  char*               hostname=((Str*)args[0])->GetStr();
  int                 port=(int)((Int*)args[1])->GetInt();
  int                 rc;
  struct sockaddr_in  addr;  /* Internet type of socket address is used */
  struct hostent*     h_ent;

  if(numargs != 2) {
      cerr << "Wrong number of arguments to Socket(hostname, port) !" << endl;
      return;
  }  

  if(!hostname || !strlen(hostname))
    hostname="localhost";
  if(!port)
    port=10000;

  h_ent=gethostbyname(hostname);
  if(!h_ent) {
    perror(0);
    return;
  }  

  _sockfd=socket(AF_INET, SOCK_STREAM, 0);
  if(_sockfd == -1) {
      perror(0);
      return;
  }

  bzero((char*)&addr, sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_addr.s_addr=((struct in_addr*)h_ent->h_addr_list[0])->s_addr;
  addr.sin_port=htons(port);

#ifndef __linux__
  addr.sin_len=sizeof(addr);
#endif

  rc=connect(_sockfd, (struct sockaddr*)&addr, sizeof(addr));
  if(rc) {
    perror(0);
    close(_sockfd);
    _sockfd=-1;
    return;
  }

  /* Set socket to non-blocking */
  fcntl(_sockfd, F_SETFL, O_NONBLOCK);

}


Socket::~Socket() {
  
}


Socket* Socket::Copy() {
  return new Socket(_sockfd);
}


void Socket::Print(ostream& os) {
    os << "<Instance of Socket ";
    if(IsValid())
	os << "(opened)";
    else
	os << "(closed)";
    os << ">";
}


void Socket::Inspect(ostream& os) {
  Print(os);
  os << "Methods:\n-----------\n\n";
  os << "Write(string): writes the string to the socket, returns number"
      " of bytes written" << endl;
  os << "Socket(hostname, port): Constructor, takes hostname (string) and "
      "port (number)" << endl;
  os << "Read(): returns the token that was read or NULL" << endl;
  os << "Close(): closes the socket" << endl;
  os << endl;
}


void Socket::Dump(ostream& os) {
  os << NATIVE_INST_TYPE << " Socket ";
  os << START_DEL;
  os << END_DEL;
}


// object_model class_name

void Socket::Read(istream& is) {
  char  buf[0xff], *clname=0, *om="Corba";

  is >> ws >> buf >> ws;
  om=strdup(buf);
  
  is >> buf >> ws;
  clname=strdup(buf);  


  delete [] om;
  delete [] clname;
}




Expr*  Socket::Write(Elist& args) {
    if(args.Size() != 1) {
	cerr << "Socket::Write(string) has 1 argument !" << endl;
	return 0;
    }
    if(_sockfd == -1) {
	cerr << "Socket is not open !" << endl;
	return 0;
    }
    char* s=((Str*)args[0])->GetStr();
    char* buf=strdup(s);
    int numbytes=write(_sockfd, buf, strlen(buf));
    if(numbytes <= 0)
	perror(0);
    delete [] buf;
    return new Int(numbytes);
}


Expr* Socket::ReadToken(Elist& args) {
    DynamicString  d;
    char           buf[8];
    int            numbytes;

    if(_sockfd == -1) {
	cerr << "Socket is not open !" << endl;
	return 0;
    }

    while(1) {
	bzero(buf, sizeof(buf));
	numbytes=read(_sockfd, buf, 1);
	if(numbytes <= 0)
	    break;
	else if(buf[0] == ' ' || buf[0] == '\n' ||
		buf[0] == '\t')
	    break;
	else
	    d << (char)buf[0];	
    }
    if(d.Size() > 0)
	return new Str(d);
    return new NilVal();
}


Expr* Socket::Close(Elist& args) {
    if(_sockfd != -1) {
	close(_sockfd);
	_sockfd=-1;
    }
    return 0;
}

