
#include <errno.h>
#include <unistd.h>
#include "defs.h"

extern "C" {
  #include <pthread.h>
}


static short      event_loop_running=0;
static pthread_t  event_thread=0;

/* ---------------------------------------------------------------------------
   Function prototypes
   --------------------------------------------------------------------------- */

/* ---------------------------------------------------------------------------
   Function list and entry point
   --------------------------------------------------------------------------- */

static FuncDescr functions[]={0};


typedef Expr* (NativeInstance::* MethPtr)(Elist&);


class Thread : public NativeInstance {  
public:
             Thread() : NativeInstance("Thread") {}
             Thread(Elist& args);  // classname args
             ~Thread();
  Thread*    Copy() {return 0;}
  void       Print(ostream& os=cout) {os << "<Instance of Thread>";}
  void       Inspect(ostream& os=cout) {}
  Symbol*    Lookup(char* name) {return 0;}
  Symbol*    Find(char* name) {return 0;}
  

  Expr*      Ctor(Elist&              args);
};




NativeInstance* MakeThread(Elist& args) {
  return new Thread(args);
}


MethodDescr Thread_methods[]={
  0
};

static ClassDescr classes[]={
  {"Thread", 0, MakeThread, 
   Thread_methods
  }, 
  0
  };



void* Foo(void*) {
  for(;;) {
    printf("Hello\n");
    sleep(5);
  }
}


void LoadFunction() {

  int rc=pthread_create(&event_thread, 0, Foo, 0);
  if(rc != 0) {
    cerr << "Thread could not be created !" << endl;
    return;
  }  

}


void UnLoadFunction() {
  if(event_thread)
    pthread_kill(&event_thread, 2);  // kill the event loop thread
  event_thread=0;  // in case of reloading...
}


static Contents contents={functions, classes, LoadFunction, UnLoadFunction};

Contents* EntryPoint() {return &contents;}



/* ---------------------------------------------------------------------------
   Implementation
   --------------------------------------------------------------------------- */


Thread::Thread(Elist& args) : NativeInstance("Thread") {
}

  
Thread::~Thread() {

}

