
#include <errno.h>
#include <unistd.h>
#include "defs.h"
#include "Windows.h"

extern "C" {
  #include <pthread.h>
}


static short      event_loop_running=0;
static pthread_t  event_thread=0;
static GomApp*    gom_app;

/* ---------------------------------------------------------------------------
   Function prototypes
   --------------------------------------------------------------------------- */

/* ---------------------------------------------------------------------------
   Function list and entry point
   --------------------------------------------------------------------------- */

static FuncDescr functions[]={0};


typedef Expr* (NativeInstance::* MethPtr)(Elist&);


class Win : public NativeInstance {  
  vWindow*   _win;
public:
             Win(char* name, int x, int y) : NativeInstance("Win"), _win(0) {}
             Win(Elist& args);  // classname args
             ~Win();
  Win*       Copy() {return 0;}
  void       Print(ostream& os=cout) {os << "<Instance of Win>";}
  void       Inspect(ostream& os=cout) {}
  Symbol*    Lookup(char* name) {return 0;}
  Symbol*    Find(char* name) {return 0;}
  

  Expr*      Ctor(Elist&              args);
};




NativeInstance* MakeWin(Elist& args) {
  return new Win(args);
}


MethodDescr Win_methods[]={
  0
};

static ClassDescr classes[]={
  {"Win", 0, MakeWin, 
   Win_methods
  }, 
  0
  };


// we don't yet create any windows...
int AppMain(int argc, char** argv) {  // never called 
  return 0;
}


void LoadFunction() {
  int dummy=0;

  gom_app=new GomApp("BelaApp");

  if(!theApp) {
    cerr << "The global app ptr is NULL !" << endl;
    cerr << "V windowing toolkit cannot be initialized ! " << endl;
    return;
  }


  ((GomApp*)theApp)->initialize(dummy, 0);	// Create top level widget
}


void UnLoadFunction() {
  if(event_thread)
    pthread_detach(&event_thread);  // kill the event loop thread
  event_thread=0;  // in case of reloading...
  delete gom_app;
}


static Contents contents={functions, classes, LoadFunction, UnLoadFunction};

Contents* EntryPoint() {return &contents;}



/* ---------------------------------------------------------------------------
   Implementation
   --------------------------------------------------------------------------- */

extern "C" {
  void* StartEventLoop(void*) {
    if(!theApp) {
      cerr << "StartEventLoop: the global app ptr is NULL !" << endl;
      cerr << "Event loop thread is terminated !" << endl;
      return 0;
    }
    ((GomApp*)theApp)->doEventLoop();  // And enter the event loop  
      return 0;
  } 
}



Win::Win(Elist& args) : NativeInstance("Win") {
  if(args.Size() != 3) {
    cerr << "Win::Win(name, x, y) ! " << endl;
    return;
  }
  char* n=((Str*)args[0])->GetStr();
  int   x=(int)((Int*)args[1])->GetInt();
  int   y=(int)((Int*)args[2])->GetInt();
  
  _win=theApp->NewAppWin(0, n, x, y, 0);  

  if(!event_loop_running) {

    int rc=pthread_create(&event_thread, &pthread_attr_default, StartEventLoop, 0);

    // if(rc != 0 ) {
    //   cerr << "Event loop thread creation failed !" << endl;
    //   return;
    // }    
    
    event_loop_running=1;
  }

}

  
Win::~Win() {
  delete _win;
}

