
#include "Windows.h"
#include "../Grammar.h"





static vMenu FileMenu[] = {
  {"New",M_New,isSens,notChk,noKeyLbl,noKey,noSub},
  {"Exit",M_Exit,isSens,notChk,noKeyLbl,noKey,noSub},
  {NULL}
};

vMenu StandardMenu[] = {
  {"File",M_File,isSens,notUsed,notUsed,noKey,&FileMenu[0]},
  {NULL}
};



//======================>>> GomWindow::GomWindow <<<====================
GomWindow::GomWindow(char* name, int height, int width) :
  vCmdWindow(name, height, width) 
{      
  myMenu = new vMenuPane(StandardMenu);
  AddPane(myMenu);
  // myCanvas = new tCanvasPane;
  // AddPane(myCanvas);
  ShowWindow();
}

//=====================>>> GomWindow::~GomWindow <<<====================
GomWindow::~GomWindow()
{    
  delete myMenu;
  // delete myCanvas;
}

//========================>>> GomWindow::KeyIn <<<=======================
void GomWindow::KeyIn(vKey keysym, unsigned int shift)
{
}

//====================>>> GomWindow::WindowCommand <<<===================
void GomWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType) {
  static int cmdCount = 0;    // Used for sample status update
  // vNoticeDialog note(this);   // Used for default actions
  char buff[20];              // buffer for status bar


  switch (id) {
  case M_Exit:   
    {            
      theApp->Exit();
      break;         
    }      
  case M_New: 
    {
      InterpretString("d=34;");
      InterpretString("println d;");
      InterpretString("b=new Win(\"Bela Ban\", 200, 300);");
      // LoadFile("cmd.bas");
    }
  default:         
    {              
      vCmdWindow::WindowCommand(id, val, cType);
      break;
    }
  }
}


vWindow* GomApp::NewAppWin(vWindow* win, char* name, int h, int w,
			   vAppWinInfo* winInfo) {
  vWindow* thisWin = win;             // local copy to use
  vAppWinInfo* awinfo = winInfo;
  char *myname = name;                // local copy
  
  if (!name || !*name)
    myname = "Example";            // make up a name
  
  UserDebug1(Build,"GomApp::NewAppWin(%s)\n",myname);
  
  if (!thisWin)       // Didn't provide a window, so create one.
    thisWin = new GomWindow(myname, h, w);
  
  if (!awinfo)        // Did caller provide an appinfo?
    awinfo = new vAppWinInfo(myname);

  return vApp::NewAppWin(thisWin,name,h,w,awinfo);
}


//===========================>>> GomApp::Exit <<<=========================
void GomApp::Exit(void) {
  UserDebug(Build,"GomApp::Exit()\n");
  
  vApp::Exit();       // easy default behavior
}

//======================>>> GomApp::CloseAppWin <<<=======================
void GomApp::CloseAppWin(vWindow* win) {
  UserDebug(Build,"GomApp::CloseAppWin()\n");
  vApp::CloseAppWin(win);   // Unregister and close the window.
}

//=====================>>> GomApp::AppCommand <<<=========================
void GomApp::AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType) {
  UserDebug1(Build,"GomApp::AppCmd(ID: %d)\n",id);
  vApp::AppCommand(win, id, val, cType);
}

//=======================>>> GomApp::KeyIn <<<============================
void GomApp::KeyIn(vWindow* win, vKey key, unsigned int shift) {
  vApp::KeyIn(win, key, shift);
}


void GomApp::initialize(int& argc, char** argv) {
  vApp::initialize(argc, argv);
}

void GomApp::doEventLoop() {
  vApp::doEventLoop();
}
