#ifndef DEFS_H
#define DEFS_H

#include "Grammar.h"

typedef CL_List<Expr*> Elist;
typedef NativeInstance* (*Constructor)(Elist&);
typedef void (*FuncPtr)();

struct DLL_Info {
  void*    dll_handle;
  FuncPtr  unload_func;
};

struct FuncDescr {
  char*         name;
  void*         addr;
  int           number_of_args;
  BType*        parm_types;     // Array of BTypes...
};

struct MethodDescr {
  char*         name;
  MethodPtr     mptr;
  int           number_of_formal_parms;
  BType*        parm_types;     // Array of BTypes
};

struct ClassDescr {
  char*         name;
  char*         superclass;
  Constructor   ctor;
  MethodDescr*  methods;
};

struct Contents  {
  FuncDescr*    functions;
  ClassDescr*   classes;
  FuncPtr       load_func;    /* called when DLL is loaded   */
  FuncPtr       unload_func;  /* called when DLL is unloaded */
};

#endif
