#include "valueAccess.h"

//=========================================================================
//
// CLASS: valueAcces, Method: readPipe (int, char *)
//
// Input parameters:
//
//	fd : 
//	  a descriptor for the reading side of a pipe created by the 
//	  caller to this routine.
//	ptr : 
//	  a pointer to a buffer that the caller provides which will
//	  hold the data read from the pipe.
//
// return value:
//
//	n : 
//	  The number of bytes read from the pipe or an error value.
//
//=========================================================================

int valueAccess :: readPipe (int fd, char *ptr) 
{
  int n, i = 0;

  // Read characters from fd until read () returns a value less or
  // equal to zero. A value less than zero means, an error has occured, 
  // a value equal to zero means there is no more data to be read from the pipe.
  
  while( ( n = read( fd, ptr+i, 1 ) ) > 0 )
    if( *(ptr+i) == '\0' ) {
      return n;
    }
    else if( i == BUFFERSIZE - 1 ) {

      // Buffersize exceeded. 

      return ERROR;
    }
    else
      ++i;
  if( n < 0 ) { 
    return n;
  }
  *(ptr+i) = '\0';
  return n;
}

//=========================================================================
//
// CLASS: valueAcces, Method: doCall (char *)
//
// Input parameters:
//
// 	callArg :
//	  A pointer to an argument string for the requested operation.
//	  This can either be the name of a unix command or the 
//	  name of a shell script.
//
// return value:
//
//      n :
//	  The number of bytes read from the pipe or an error value.
//
//=========================================================================

int valueAccess::doCall (char *callArg)
{
  int  pid, pfd[2];
  
  // Open a pipe. This call sets two integer file descriptors in pfd
  // which can later be used to read/write from/to the pipe.

  if( pipe( pfd ) < 0 ) {
   return( ERROR );
  }

  // Fork () a second process which will be used to execute the
  // command denoted by callArg.  

  if( pid = fork() ) { 

    // Parent process.

    if ( pid < 0 ) 
      return( ERROR );

    // Close the writing side of the pipe. We have to do it here because
    // only one process may write to a pipe at the same time, which we 
    // want our child to be.

    close( pfd[1] );

    // Call readPipe (). It will read the data that (hopefully) the child
    // writes into the pipe and place it into the buffer pointed to by the class 
    // variable buf. 
    // Return the return value readPipe () produces to the caller of this routine.

    return readPipe( pfd[0], buf ); 
  }
  else { 

    // Child process.
    // Close the reading side of the pipe. We have to do it here because
    // only one process may read from a pipe at the same time, which we 
    // want our parent to be.
 
    close( pfd[0] );

    // Now close file descriptor one, which happens to be standard output. The following
    // dup () call duplicates the filedescriptor it gets as an argument. It duplicates
    // it into the first not used filedescriptor it finds which is filedescriptor one.
    // (Note that filedescriptor zero is by definition standard input.) 
    // From now on all output to the former standard output will be piped into our pipe 
    // instead of standard output. 

    close( 1 );
    if( dup( pfd[1] ) < 0 ) {
      return( ERROR );
    }

    // Execute the command given as argument. This command is the reason why we had to
    // fork () a seperate process: It overlays the image of the current program with a
    // new one. The old one is irretrievably lost.

    if( execl("/usr/bin/sh", "sh", "-c", callArg, 0) == -1 )

      // Still here? Thus execl () failed for some reason. No use going on.

      exit(-1);
  }
  return 1;  // This method promised to return an int. Thus do it even though it should 
	      // never get here.
}

//=========================================================================
//
// CLASS: activity, Method: parseActivity (char *)
//
// Input parameters:
//
//      ss :
//        A pointer to an argument string containing a line to be parsed.
//	  We are supposed to pull out tty and activity.
//
//=========================================================================

void activity :: parseActivity (char *ss)
{
  char name[4], tty[10], time[48], activity[128], *ptr3 = ss;
  int rc, first = TRUE;
  char *ptr2 = activityString;

  // Parse as long as there is something to parse.

  while (ptr3 && *ptr3) {
    if (!first)
      strcat (ptr2++, ",");
    else {
 
      // Add a header to the activityString requested by the attribute ASN.1. 

      strcat (ptr2, "(info (");
      ptr2 += strlen ("(info (");
      first = FALSE;
    }
    rc = sscanf (ptr3, "%s %s %s %s",
		 &name, &tty, &time, &activity);
    if ((rc < 4) || (strcmp (activity, "-") == 0 ) )
      sprintf (ptr2, "(ttyId %s, (unavailable unknown))", tty);
    else
      sprintf (ptr2, "(ttyId %s, (available %s))", tty, activity);
    ptr2 += strlen (ptr2);
    ptr3 = strchr( ptr3, '\n' );
    if( ptr3 && *ptr3 ) ++ptr3;
  }
  strcat (activityString, "))");
}
