package App::InteractivePerlTutorial::Chapter::Arrays::Lists;

use v5.14;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Lists';
use constant EXERCISES => [
  { statement => 'Return a three element list with elements 7,1,6 (in this order)', input => '', check => sub { $_[0] == 7 && $_[1] == 1 && $_[2] == 6}, hint => 'Use the return operator', solution => 'return (7,1,6)' },
];

1;
__DATA__

=encoding utf-8

=head1 Lists

In Perl, lists are groups of scalar separated by commas and limited by parentheses.

For example

  (1, "Alex", $x);

will be a list which on the first position is occupied by number C<1>, the second by the string C<"Alex"> and the third by the scalar C<$x>.Lists can also be empty

  C<()>

or by giving them values between 2 numbers:

  (1..6);
  $x=1;
  $y=6;
  ($x..$y)

=head2 Using C<qw>

As you can observe writing a long list of strings is time-consuming because of quotes(C<">) and comas(C<,>). To skip those we can use C<qw>.

  qw( Troll Camper book array string )

is the same as

  ('troll', 'camper', 'book', 'array', 'string')

qw ignore any tab, newline, spaces and can use other characters (C< !!//()[]{} >) as delimiters.

=head2 List Assignment

Do you remember how to assign scalar values to variables?

  $x=2;

In a similar way you can assign values to lists:

  ($x, $y, $z)=(1, "Yes", $a);

Now scalar C<$x> has the value C<1>, C<$y> has the string C<"yes"> and C<$z> the current Value of scalar C<$a>.
It's easy to swap 2 values like this:

  ($x, $z) = ($z, $x);


=cut
