/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;

final class CountingInputStream
extends InputStream {
    private final InputStream parent;
    private long count;

    CountingInputStream(InputStream parent) {
        this.parent = parent;
    }

    long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        int b = this.parent.read();
        if (b != -1) {
            ++this.count;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.parent.read(b);
        if (read != -1) {
            this.count += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.parent.read(b, off, len);
        if (read != -1) {
            this.count += (long)read;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.parent.skip(n);
        this.count += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.parent.available();
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }
}

