/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.internal.ISessionToken;
import com.microsoft.azure.cosmosdb.internal.PathInfo;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.SessionTokenHelper;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.ReplicatedResourceClientUtils;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionContainer
implements ISessionContainer {
    private final Logger logger = LoggerFactory.getLogger(SessionContainer.class);
    private final ConcurrentHashMap<Long, ConcurrentHashMap<String, ISessionToken>> collectionResourceIdToSessionTokens = new ConcurrentHashMap();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    private final ConcurrentHashMap<String, Long> collectionNameToCollectionResourceId = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, String> collectionResourceIdToCollectionName = new ConcurrentHashMap();
    private final String hostName;

    public SessionContainer(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getSessionToken(String collectionLink) {
        PathInfo pathInfo = new PathInfo(false, null, null, false);
        ConcurrentHashMap<String, ISessionToken> partitionKeyRangeIdToTokenMap = null;
        if (PathsHelper.tryParsePathSegments((String)collectionLink, (PathInfo)pathInfo, null)) {
            Long UniqueDocumentCollectionId = null;
            if (pathInfo.isNameBased) {
                String collectionName = PathsHelper.getCollectionPath((String)pathInfo.resourceIdOrFullName);
                UniqueDocumentCollectionId = this.collectionNameToCollectionResourceId.get(collectionName);
            } else {
                ResourceId resourceId = ResourceId.parse((String)pathInfo.resourceIdOrFullName);
                if (resourceId.getDocumentCollection() != 0) {
                    UniqueDocumentCollectionId = resourceId.getUniqueDocumentCollectionId();
                }
            }
            if (UniqueDocumentCollectionId != null) {
                partitionKeyRangeIdToTokenMap = this.collectionResourceIdToSessionTokens.get(UniqueDocumentCollectionId);
            }
        }
        if (partitionKeyRangeIdToTokenMap == null) {
            return "";
        }
        return SessionContainer.getCombinedSessionToken(partitionKeyRangeIdToTokenMap);
    }

    private ConcurrentHashMap<String, ISessionToken> getPartitionKeyRangeIdToTokenMap(RxDocumentServiceRequest request) {
        return this.getPartitionKeyRangeIdToTokenMap(request.getIsNameBased(), request.getResourceId(), request.getResourceAddress());
    }

    private ConcurrentHashMap<String, ISessionToken> getPartitionKeyRangeIdToTokenMap(boolean isNameBased, String rId, String resourceAddress) {
        ConcurrentHashMap<String, ISessionToken> rangeIdToTokenMap = null;
        if (!isNameBased) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty((CharSequence)rId) && (resourceId = ResourceId.parse((String)rId)).getDocumentCollection() != 0) {
                rangeIdToTokenMap = this.collectionResourceIdToSessionTokens.get(resourceId.getUniqueDocumentCollectionId());
            }
        } else {
            String collectionName = Utils.getCollectionName((String)resourceAddress);
            if (!StringUtils.isEmpty((CharSequence)collectionName) && this.collectionNameToCollectionResourceId.containsKey(collectionName)) {
                rangeIdToTokenMap = this.collectionResourceIdToSessionTokens.get(this.collectionNameToCollectionResourceId.get(collectionName));
            }
        }
        return rangeIdToTokenMap;
    }

    @Override
    public String resolveGlobalSessionToken(RxDocumentServiceRequest request) {
        ConcurrentHashMap<String, ISessionToken> partitionKeyRangeIdToTokenMap = this.getPartitionKeyRangeIdToTokenMap(request);
        if (partitionKeyRangeIdToTokenMap != null) {
            return SessionContainer.getCombinedSessionToken(partitionKeyRangeIdToTokenMap);
        }
        return "";
    }

    @Override
    public ISessionToken resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId) {
        return SessionTokenHelper.resolvePartitionLocalSessionToken(request, partitionKeyRangeId, this.getPartitionKeyRangeIdToTokenMap(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTokenByCollectionFullName(String collectionFullName) {
        if (!Strings.isNullOrEmpty((String)collectionFullName)) {
            String collectionName = PathsHelper.getCollectionPath((String)collectionFullName);
            this.writeLock.lock();
            try {
                if (this.collectionNameToCollectionResourceId.containsKey(collectionName)) {
                    Long rid = this.collectionNameToCollectionResourceId.get(collectionName);
                    this.collectionResourceIdToSessionTokens.remove(rid);
                    this.collectionResourceIdToCollectionName.remove(rid);
                    this.collectionNameToCollectionResourceId.remove(collectionName);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTokenByResourceId(String resourceId) {
        ResourceId resource;
        if (!StringUtils.isEmpty((CharSequence)resourceId) && (resource = ResourceId.parse((String)resourceId)).getDocumentCollection() != 0) {
            Long rid = resource.getUniqueDocumentCollectionId();
            this.writeLock.lock();
            try {
                if (this.collectionResourceIdToCollectionName.containsKey(rid)) {
                    String collectionName = this.collectionResourceIdToCollectionName.get(rid);
                    this.collectionResourceIdToSessionTokens.remove(rid);
                    this.collectionResourceIdToCollectionName.remove(rid);
                    this.collectionNameToCollectionResourceId.remove(collectionName);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void setSessionToken(RxDocumentServiceRequest request, Map<String, String> responseHeaders) {
        Utils.ValueHolder collectionName;
        Utils.ValueHolder resourceId;
        String token = responseHeaders.get("x-ms-session-token");
        if (!Strings.isNullOrEmpty((String)token) && SessionContainer.shouldUpdateSessionToken(request, responseHeaders, (Utils.ValueHolder<ResourceId>)(resourceId = Utils.ValueHolder.initialize(null)), (Utils.ValueHolder<String>)(collectionName = Utils.ValueHolder.initialize(null)))) {
            this.setSessionToken((ResourceId)resourceId.v, (String)collectionName.v, token);
        }
    }

    @Override
    public void setSessionToken(String collectionRid, String collectionFullName, Map<String, String> responseHeaders) {
        ResourceId resourceId = ResourceId.parse((String)collectionRid);
        String collectionName = PathsHelper.getCollectionPath((String)collectionFullName);
        String token = responseHeaders.get("x-ms-session-token");
        if (!Strings.isNullOrEmpty((String)token)) {
            this.setSessionToken(resourceId, collectionName, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionToken(ResourceId resourceId, String collectionName, String token) {
        boolean isKnownCollection;
        String[] tokenParts = StringUtils.split((String)token, (char)':');
        String partitionKeyRangeId = tokenParts[0];
        ISessionToken parsedSessionToken = SessionTokenHelper.parse(tokenParts[1]);
        this.logger.trace("Update Session token {} {} {}", new Object[]{resourceId.getUniqueDocumentCollectionId(), collectionName, parsedSessionToken});
        this.readLock.lock();
        try {
            boolean bl = isKnownCollection = this.collectionNameToCollectionResourceId.containsKey(collectionName) && this.collectionResourceIdToCollectionName.containsKey(resourceId.getUniqueDocumentCollectionId()) && this.collectionNameToCollectionResourceId.get(collectionName).longValue() == resourceId.getUniqueDocumentCollectionId() && this.collectionResourceIdToCollectionName.get(resourceId.getUniqueDocumentCollectionId()).equals(collectionName);
            if (isKnownCollection) {
                this.addSessionToken(resourceId, partitionKeyRangeId, parsedSessionToken);
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (!isKnownCollection) {
            this.writeLock.lock();
            try {
                if (collectionName != null && resourceId.getUniqueDocumentCollectionId() != 0L) {
                    this.collectionNameToCollectionResourceId.compute(collectionName, (k, v) -> resourceId.getUniqueDocumentCollectionId());
                    this.collectionResourceIdToCollectionName.compute(resourceId.getUniqueDocumentCollectionId(), (k, v) -> collectionName);
                }
                this.addSessionToken(resourceId, partitionKeyRangeId, parsedSessionToken);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private void addSessionToken(ResourceId resourceId, String partitionKeyRangeId, ISessionToken parsedSessionToken) {
        this.collectionResourceIdToSessionTokens.compute(resourceId.getUniqueDocumentCollectionId(), (k, existingTokens) -> {
            if (existingTokens == null) {
                ConcurrentHashMap<String, ISessionToken> tokens = new ConcurrentHashMap<String, ISessionToken>();
                tokens.put(partitionKeyRangeId, parsedSessionToken);
                return tokens;
            }
            existingTokens.merge(partitionKeyRangeId, parsedSessionToken, (existingSessionTokens, newSessionToken) -> {
                try {
                    if (existingSessionTokens == null) {
                        return newSessionToken;
                    }
                    return existingSessionTokens.merge(newSessionToken);
                }
                catch (DocumentClientException e) {
                    throw new IllegalStateException(e);
                }
            });
            return existingTokens;
        });
    }

    private static String getCombinedSessionToken(ConcurrentHashMap<String, ISessionToken> tokens) {
        StringBuilder result = new StringBuilder();
        if (tokens != null) {
            Iterator<Map.Entry<String, ISessionToken>> iterator = tokens.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ISessionToken> entry = iterator.next();
                result = result.append(entry.getKey()).append(":").append(entry.getValue().convertToString());
                if (!iterator.hasNext()) continue;
                result = result.append(",");
            }
        }
        return result.toString();
    }

    private static boolean shouldUpdateSessionToken(RxDocumentServiceRequest request, Map<String, String> responseHeaders, Utils.ValueHolder<ResourceId> resourceId, Utils.ValueHolder<String> collectionName) {
        String resourceIdString;
        resourceId.v = null;
        String ownerFullName = responseHeaders.get("x-ms-alt-content-path");
        if (Strings.isNullOrEmpty((String)ownerFullName)) {
            ownerFullName = request.getResourceAddress();
        }
        collectionName.v = PathsHelper.getCollectionPath((String)ownerFullName);
        if (!request.getIsNameBased()) {
            resourceIdString = request.getResourceId();
        } else {
            resourceIdString = responseHeaders.get("x-ms-content-path");
            if (Strings.isNullOrEmpty((String)resourceIdString)) {
                resourceIdString = request.getResourceId();
            }
        }
        if (!Strings.isNullOrEmpty((String)resourceIdString)) {
            resourceId.v = ResourceId.parse((String)resourceIdString);
            if (((ResourceId)resourceId.v).getDocumentCollection() != 0 && collectionName != null && !ReplicatedResourceClientUtils.isReadingFromMaster(request.getResourceType(), request.getOperationType())) {
                return true;
            }
        }
        return false;
    }
}

