/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.RegexMountPointInterceptorType;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestViewFileSystemLinkRegex
extends ViewFileSystemBaseTest {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestViewFileSystemLinkRegex.class);
    private static FileSystem fsDefault;
    private static MiniDFSCluster cluster;
    private static Configuration clusterConfig;
    private static final int NAME_SPACES_COUNT = 3;
    private static final int DATA_NODES_COUNT = 3;
    private static final int FS_INDEX_DEFAULT = 0;
    private static final FileSystem[] FS_HDFS;
    private static final String CLUSTER_NAME = "TestViewFileSystemLinkRegexCluster";
    private static final File TEST_DIR;
    private static final String TEST_BASE_PATH = "/tmp/TestViewFileSystemLinkRegex";

    protected FileSystemTestHelper createFileSystemHelper() {
        return new FileSystemTestHelper(TEST_BASE_PATH);
    }

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException {
        SupportsBlocks = true;
        clusterConfig = ViewFileSystemTestSetup.createConfig();
        clusterConfig.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(clusterConfig).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).numDataNodes(3).build();
        cluster.waitClusterUp();
        for (int i = 0; i < 3; ++i) {
            TestViewFileSystemLinkRegex.FS_HDFS[i] = cluster.getFileSystem(i);
        }
        fsDefault = FS_HDFS[0];
    }

    @AfterClass
    public static void clusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fsDefault;
        super.setUp();
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = fsDefault.makeQualified(new Path("/"));
        for (FileStatus status : fsDefault.listStatus(this.targetTestRoot)) {
            fsDefault.delete(status.getPath(), true);
        }
    }

    void setupMountPoints() {
        super.setupMountPoints();
    }

    int getExpectedDelegationTokenCount() {
        return 1;
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 1;
    }

    public String buildReplaceInterceptorSettingString(String srcRegex, String replaceString) {
        return RegexMountPointInterceptorType.REPLACE_RESOLVED_DST_PATH.getConfigName() + ':' + srcRegex + ':' + replaceString;
    }

    public String linkInterceptorSettings(List<String> interceptorSettingStrList) {
        StringBuilder stringBuilder = new StringBuilder();
        int listSize = interceptorSettingStrList.size();
        for (int i = 0; i < listSize; ++i) {
            stringBuilder.append(interceptorSettingStrList.get(i));
            if (i >= listSize - 1) continue;
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    private void createDirWithChildren(FileSystem fileSystem, Path dir, List<Path> childrenFiles) throws IOException {
        Assert.assertTrue((boolean)fileSystem.mkdirs(dir));
        int index = 0;
        for (Path childFile : childrenFiles) {
            this.createFile(fileSystem, childFile, index, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(FileSystem fileSystem, Path file, int dataLenToWrite, boolean overwrite) throws IOException {
        try (FSDataOutputStream outputStream = null;){
            outputStream = fileSystem.create(file, overwrite);
            for (int i = 0; i < dataLenToWrite; ++i) {
                outputStream.writeByte(i);
            }
            outputStream.close();
        }
    }

    private void createDirWithChildren(FileSystem fileSystem, Path dir, int childrenFilesCnt) throws IOException {
        ArrayList<Path> childrenFiles = new ArrayList<Path>(childrenFilesCnt);
        for (int i = 0; i < childrenFilesCnt; ++i) {
            childrenFiles.add(new Path(dir, "file" + i));
        }
        this.createDirWithChildren(fileSystem, dir, childrenFiles);
    }

    private void testRegexMountpoint(Configuration config, String regexStr, String dstPathStr, String interceptorSettings, Path dirPathBeforeMountPoint, Path expectedResolveResult, int childrenFilesCnt) throws IOException, URISyntaxException {
        this.createDirWithChildren(this.fsTarget, expectedResolveResult, childrenFilesCnt);
        ConfigUtil.addLinkRegex((Configuration)config, (String)CLUSTER_NAME, (String)regexStr, (String)dstPathStr, (String)interceptorSettings);
        URI viewFsUri = new URI("viewfs", CLUSTER_NAME, "/", null, null);
        try (FileSystem vfs = FileSystem.get((URI)viewFsUri, (Configuration)config);){
            Assert.assertEquals((Object)expectedResolveResult.toString(), (Object)vfs.resolvePath(dirPathBeforeMountPoint).toString());
            Assert.assertTrue((boolean)vfs.getFileStatus(dirPathBeforeMountPoint).isDirectory());
            Assert.assertEquals((long)childrenFilesCnt, (long)vfs.listStatus(dirPathBeforeMountPoint).length);
            ViewFileSystem viewFileSystem = (ViewFileSystem)vfs;
            ChRootedFileSystem target1 = (ChRootedFileSystem)viewFileSystem.fsState.resolve((String)viewFileSystem.getUriPath((Path)dirPathBeforeMountPoint), (boolean)true).targetFileSystem;
            ChRootedFileSystem target2 = (ChRootedFileSystem)viewFileSystem.fsState.resolve((String)viewFileSystem.getUriPath((Path)dirPathBeforeMountPoint), (boolean)true).targetFileSystem;
            Assert.assertSame((Object)target1.getMyFs(), (Object)target2.getMyFs());
        }
    }

    @Test
    public void testConfLinkRegexIndexMapping() throws Exception {
        String regexStr = "^/(\\w+)";
        String dstPathStr = this.targetTestRoot + "$1";
        Path srcPath = new Path("/testConfLinkRegexIndexMapping1");
        Path expectedResolveResult = new Path(dstPathStr.replace("$1", "testConfLinkRegexIndexMapping1"));
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, null, srcPath, expectedResolveResult, 3);
        dstPathStr = this.targetTestRoot + "${1}";
        srcPath = new Path("/testConfLinkRegexIndexMapping2");
        expectedResolveResult = new Path(dstPathStr.replace("${1}", "testConfLinkRegexIndexMapping2"));
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, null, srcPath, expectedResolveResult, 4);
        dstPathStr = this.targetTestRoot + "$1";
        srcPath = new Path("/testConfLinkRegexIndexMapping3/dir1");
        expectedResolveResult = new Path(dstPathStr.replace("$1", "testConfLinkRegexIndexMapping3/dir1"));
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, null, srcPath, expectedResolveResult, 5);
        dstPathStr = this.targetTestRoot + "${1}/";
        srcPath = new Path("/testConfLinkRegexIndexMapping4/dir1");
        expectedResolveResult = new Path(dstPathStr.replace("${1}", "testConfLinkRegexIndexMapping4/dir1"));
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, null, srcPath, expectedResolveResult, 6);
    }

    @Test
    public void testConfLinkRegexNamedGroupMapping() throws Exception {
        URI viewFsUri = new URI("viewfs", CLUSTER_NAME, "/", null, null);
        String regexStr = "^/(?<firstDir>\\w+)";
        String dstPathStr = this.targetTestRoot + "$firstDir";
        Path srcPath = new Path("/testConfLinkRegexNamedGroupMapping1");
        Path expectedResolveResult = new Path(dstPathStr.replace("$firstDir", "testConfLinkRegexNamedGroupMapping1"));
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, null, srcPath, expectedResolveResult, 3);
        dstPathStr = this.targetTestRoot + "${firstDir}";
        srcPath = new Path("/testConfLinkRegexNamedGroupMapping2");
        expectedResolveResult = new Path(dstPathStr.replace("${firstDir}", "testConfLinkRegexNamedGroupMapping2"));
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, null, srcPath, expectedResolveResult, 5);
    }

    @Test
    public void testConfLinkRegexFixedDestMapping() throws Exception {
        String regexStr = "^/\\w+";
        String dstPathStr = this.targetTestRoot + "testConfLinkRegexFixedDestMappingFile";
        Path expectedResolveResult = new Path(dstPathStr);
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, null, new Path("/misc1"), expectedResolveResult, 5);
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, null, new Path("/misc2"), expectedResolveResult, 6);
    }

    @Test
    public void testConfLinkRegexWithSingleInterceptor() throws Exception {
        String regexStr = "^/user/(?<username>\\w+)";
        String dstPathStr = this.targetTestRoot + "$username";
        String settingString = this.buildReplaceInterceptorSettingString("_", "-");
        Path srcPath = new Path("/user/hadoop_user1/hadoop_dir1");
        Path expectedResolveResult = new Path(this.targetTestRoot, "hadoop-user1/hadoop_dir1");
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, settingString, srcPath, expectedResolveResult, 2);
    }

    @Test
    public void testConfLinkRegexWithInterceptors() throws Exception {
        String regexStr = "^/user/(?<username>\\w+)/";
        String dstPathStr = this.targetTestRoot + "$username";
        String interceptor1 = this.buildReplaceInterceptorSettingString("_", "-");
        String interceptor2 = this.buildReplaceInterceptorSettingString("hadoop", "hdfs");
        String interceptors = this.linkInterceptorSettings(Arrays.asList(interceptor1, interceptor2));
        Path srcPath = new Path("/user/hadoop_user1/hadoop_dir1");
        Path expectedResolveResult = new Path(this.targetTestRoot, "hdfs-user1/hadoop_dir1");
        this.testRegexMountpoint(new Configuration(this.conf), regexStr, dstPathStr, interceptors, srcPath, expectedResolveResult, 2);
    }

    static {
        FS_HDFS = new FileSystem[3];
        TEST_DIR = GenericTestUtils.getTestDir((String)TestViewFileSystemLinkRegex.class.getSimpleName());
    }
}

