/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JDefinedClass;
import org.jsonschema2pojo.AbstractAnnotator;
import org.jsonschema2pojo.GenerationConfig;

public abstract class AbstractTypeInfoAwareAnnotator
extends AbstractAnnotator {
    public AbstractTypeInfoAwareAnnotator(GenerationConfig generationConfig) {
        super(generationConfig);
    }

    @Override
    public void typeInfo(JDefinedClass clazz, JsonNode node) {
        if (this.getGenerationConfig().isIncludeTypeInfo()) {
            if (node.has("deserializationClassProperty")) {
                String annotationName = node.get("deserializationClassProperty").asText();
                this.addJsonTypeInfoAnnotation(clazz, annotationName);
            } else {
                this.addJsonTypeInfoAnnotation(clazz, "@class");
            }
        } else if (node.has("deserializationClassProperty")) {
            String annotationName = node.get("deserializationClassProperty").asText();
            this.addJsonTypeInfoAnnotation(clazz, annotationName);
        }
    }

    @Override
    public boolean isPolymorphicDeserializationSupported(JsonNode node) {
        return this.getGenerationConfig().isIncludeTypeInfo() || node.has("deserializationClassProperty");
    }

    protected abstract void addJsonTypeInfoAnnotation(JDefinedClass var1, String var2);
}

