/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.state;

import java.io.IOException;
import org.apache.hadoop.tools.rumen.state.State;
import org.apache.hadoop.tools.rumen.state.StatePool;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.node.ObjectNode;

public class StateDeserializer
extends StdDeserializer<StatePool.StatePair> {
    public StateDeserializer() {
        super(StatePool.StatePair.class);
    }

    public StatePool.StatePair deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        ObjectNode statePairObject = (ObjectNode)mapper.readTree(parser);
        Class<?> stateClass = null;
        try {
            stateClass = Class.forName(statePairObject.get("className").getTextValue().trim());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Invalid classname!", cnfe);
        }
        String stateJsonString = statePairObject.get("state").toString();
        State state = (State)mapper.readValue(stateJsonString, stateClass);
        return new StatePool.StatePair(state);
    }
}

