/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredsTokenProvider
extends AccessTokenProvider {
    private final String authEndpoint;
    private final String clientId;
    private final String clientSecret;
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);

    public ClientCredsTokenProvider(String authEndpoint, String clientId, String clientSecret) {
        Preconditions.checkNotNull((Object)authEndpoint, (Object)"authEndpoint");
        Preconditions.checkNotNull((Object)clientId, (Object)"clientId");
        Preconditions.checkNotNull((Object)clientSecret, (Object)"clientSecret");
        this.authEndpoint = authEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing client-credential based token");
        return AzureADAuthenticator.getTokenUsingClientCreds(this.authEndpoint, this.clientId, this.clientSecret);
    }
}

