/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.LongSumReducer;
import org.apache.hadoop.mapreduce.lib.map.RegexMapper;
import org.apache.hadoop.tools.DistCpV1;

@Deprecated
public class Logalyzer {
    private static Configuration fsConfig = new Configuration();
    public static final String SORT_COLUMNS = "logalizer.logcomparator.sort.columns";
    public static final String COLUMN_SEPARATOR = "logalizer.logcomparator.column.separator";

    public void doArchive(String logListURI, String archiveDirectory) throws IOException {
        String destURL = FileSystem.getDefaultUri((Configuration)fsConfig) + archiveDirectory;
        DistCpV1.copy((Configuration)new JobConf(fsConfig), logListURI, destURL, null, true, false);
    }

    public void doAnalyze(String inputFilesDirectory, String outputDirectory, String grepPattern, String sortColumns, String columnSeparator) throws IOException {
        Path grepInput = new Path(inputFilesDirectory);
        Path analysisOutput = null;
        analysisOutput = outputDirectory.equals("") ? new Path(inputFilesDirectory, "logalyzer_" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE))) : new Path(outputDirectory);
        JobConf grepJob = new JobConf(fsConfig);
        grepJob.setJobName("logalyzer-grep-sort");
        FileInputFormat.setInputPaths((JobConf)grepJob, (Path[])new Path[]{grepInput});
        grepJob.setInputFormat(TextInputFormat.class);
        grepJob.setMapperClass(LogRegexMapper.class);
        grepJob.set(RegexMapper.PATTERN, grepPattern);
        grepJob.set(SORT_COLUMNS, sortColumns);
        grepJob.set(COLUMN_SEPARATOR, columnSeparator);
        grepJob.setCombinerClass(LongSumReducer.class);
        grepJob.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath((JobConf)grepJob, (Path)analysisOutput);
        grepJob.setOutputFormat(TextOutputFormat.class);
        grepJob.setOutputKeyClass(Text.class);
        grepJob.setOutputValueClass(LongWritable.class);
        grepJob.setOutputKeyComparatorClass(LogComparator.class);
        grepJob.setNumReduceTasks(1);
        JobClient.runJob((JobConf)grepJob);
    }

    public static void main(String[] args) {
        Log LOG = LogFactory.getLog(Logalyzer.class);
        String version = "Logalyzer.0.0.1";
        String usage = "Usage: Logalyzer [-archive -logs <urlsFile>] -archiveDir <archiveDirectory> -grep <pattern> -sort <column1,column2,...> -separator <separator> -analysis <outputDirectory>";
        System.out.println(version);
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        boolean archive = false;
        boolean grep = false;
        boolean sort = false;
        String archiveDir = "";
        String logListURI = "";
        String grepPattern = ".*";
        String sortColumns = "";
        String columnSeparator = " ";
        String outputDirectory = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-archive")) {
                archive = true;
                continue;
            }
            if (args[i].equals("-archiveDir")) {
                archiveDir = args[++i];
                continue;
            }
            if (args[i].equals("-grep")) {
                grep = true;
                grepPattern = args[++i];
                continue;
            }
            if (args[i].equals("-logs")) {
                logListURI = args[++i];
                continue;
            }
            if (args[i].equals("-sort")) {
                sort = true;
                sortColumns = args[++i];
                continue;
            }
            if (args[i].equals("-separator")) {
                columnSeparator = args[++i];
                continue;
            }
            if (!args[i].equals("-analysis")) continue;
            outputDirectory = args[++i];
        }
        LOG.info((Object)("analysisDir = " + outputDirectory));
        LOG.info((Object)("archiveDir = " + archiveDir));
        LOG.info((Object)("logListURI = " + logListURI));
        LOG.info((Object)("grepPattern = " + grepPattern));
        LOG.info((Object)("sortColumns = " + sortColumns));
        LOG.info((Object)("separator = " + columnSeparator));
        try {
            Logalyzer logalyzer = new Logalyzer();
            if (archive) {
                logalyzer.doArchive(logListURI, archiveDir);
            }
            if (grep || sort) {
                logalyzer.doAnalyze(archiveDir, outputDirectory, grepPattern, sortColumns, columnSeparator);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    static {
        Configuration.addDeprecations((Configuration.DeprecationDelta[])new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("mapred.reducer.sort", SORT_COLUMNS), new Configuration.DeprecationDelta("mapred.reducer.separator", COLUMN_SEPARATOR)});
    }

    public static class LogComparator
    extends Text.Comparator
    implements Configurable {
        private static Log LOG = LogFactory.getLog(Logalyzer.class);
        private JobConf conf = null;
        private String[] sortSpec = null;
        private String columnSeparator = null;

        public void setConf(Configuration conf) {
            this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
            String sortColumns = this.conf.get(Logalyzer.SORT_COLUMNS, null);
            if (sortColumns != null) {
                this.sortSpec = sortColumns.split(",");
            }
            this.columnSeparator = this.conf.get(Logalyzer.COLUMN_SEPARATOR, "");
        }

        public Configuration getConf() {
            return this.conf;
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            if (this.sortSpec == null) {
                return super.compare(b1, s1, l1, b2, s2, l2);
            }
            try {
                Text logline1 = new Text();
                logline1.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(b1, s1, l1)));
                String line1 = logline1.toString();
                String[] logColumns1 = line1.split(this.columnSeparator);
                Text logline2 = new Text();
                logline2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(b2, s2, l2)));
                String line2 = logline2.toString();
                String[] logColumns2 = line2.split(this.columnSeparator);
                if (logColumns1 == null || logColumns2 == null) {
                    return super.compare(b1, s1, l1, b2, s2, l2);
                }
                for (int i = 0; i < this.sortSpec.length; ++i) {
                    int column = Integer.parseInt(this.sortSpec[i]);
                    String c1 = logColumns1[column];
                    String c2 = logColumns2[column];
                    int comparision = Text.Comparator.compareBytes((byte[])c1.getBytes(Charset.forName("UTF-8")), (int)0, (int)c1.length(), (byte[])c2.getBytes(Charset.forName("UTF-8")), (int)0, (int)c2.length());
                    if (comparision == 0) continue;
                    return comparision;
                }
            }
            catch (IOException ioe) {
                LOG.fatal((Object)("Caught " + ioe));
                return 0;
            }
            return 0;
        }

        static {
            WritableComparator.define(Text.class, (WritableComparator)new LogComparator());
        }
    }

    public static class LogRegexMapper<K extends WritableComparable>
    extends MapReduceBase
    implements Mapper<K, Text, Text, LongWritable> {
        private Pattern pattern;

        public void configure(JobConf job) {
            this.pattern = Pattern.compile(job.get(RegexMapper.PATTERN));
        }

        public void map(K key, Text value, OutputCollector<Text, LongWritable> output, Reporter reporter) throws IOException {
            String text = value.toString();
            Matcher matcher = this.pattern.matcher(text);
            while (matcher.find()) {
                output.collect((Object)value, (Object)new LongWritable(1L));
            }
        }
    }
}

