/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.oauth2;

import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.AzureADAuthenticator;
import com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsiTokenProvider
extends AccessTokenProvider {
    private static final Logger log = LoggerFactory.getLogger((String)"com.microsoft.azure.datalake.store.oauth2.MsiTokenProvider");
    private final int localPort;
    private final String tenantGuid;

    public MsiTokenProvider() {
        this(-1, null);
    }

    public MsiTokenProvider(int localPort) {
        this(localPort, null);
    }

    public MsiTokenProvider(int localPort, String tenantGuid) {
        this.localPort = localPort;
        this.tenantGuid = tenantGuid;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        log.debug("AADToken: refreshing token from MSI");
        return AzureADAuthenticator.getTokenFromMsi(this.localPort, this.tenantGuid);
    }
}

