/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMNodeWrapper
implements RMNode {
    private RMNode node;
    private List<UpdatedContainerInfo> updates;
    private boolean pulled = false;

    public RMNodeWrapper(RMNode node) {
        this.node = node;
        this.updates = node.pullContainerUpdates();
    }

    public NodeId getNodeID() {
        return this.node.getNodeID();
    }

    public String getHostName() {
        return this.node.getHostName();
    }

    public int getCommandPort() {
        return this.node.getCommandPort();
    }

    public int getHttpPort() {
        return this.node.getHttpPort();
    }

    public String getNodeAddress() {
        return this.node.getNodeAddress();
    }

    public String getHttpAddress() {
        return this.node.getHttpAddress();
    }

    public String getHealthReport() {
        return this.node.getHealthReport();
    }

    public long getLastHealthReportTime() {
        return this.node.getLastHealthReportTime();
    }

    public Resource getTotalCapability() {
        return this.node.getTotalCapability();
    }

    public String getRackName() {
        return this.node.getRackName();
    }

    public Node getNode() {
        return this.node.getNode();
    }

    public NodeState getState() {
        return this.node.getState();
    }

    public List<ContainerId> getContainersToCleanUp() {
        return this.node.getContainersToCleanUp();
    }

    public List<ApplicationId> getAppsToCleanup() {
        return this.node.getAppsToCleanup();
    }

    public List<ApplicationId> getRunningApps() {
        return this.node.getRunningApps();
    }

    public void setAndUpdateNodeHeartbeatResponse(NodeHeartbeatResponse nodeHeartbeatResponse) {
        this.node.setAndUpdateNodeHeartbeatResponse(nodeHeartbeatResponse);
    }

    public NodeHeartbeatResponse getLastNodeHeartBeatResponse() {
        return this.node.getLastNodeHeartBeatResponse();
    }

    public void resetLastNodeHeartBeatResponse() {
        this.node.getLastNodeHeartBeatResponse().setResponseId(0);
    }

    public List<UpdatedContainerInfo> pullContainerUpdates() {
        List<UpdatedContainerInfo> list = Collections.EMPTY_LIST;
        if (!this.pulled) {
            list = this.updates;
            this.pulled = true;
        }
        return list;
    }

    List<UpdatedContainerInfo> getContainerUpdates() {
        return this.updates;
    }

    public String getNodeManagerVersion() {
        return this.node.getNodeManagerVersion();
    }

    public Set<String> getNodeLabels() {
        return RMNodeLabelsManager.EMPTY_STRING_SET;
    }

    public List<Container> pullNewlyIncreasedContainers() {
        return Collections.EMPTY_LIST;
    }

    public OpportunisticContainersStatus getOpportunisticContainersStatus() {
        return null;
    }

    public ResourceUtilization getAggregatedContainersUtilization() {
        return this.node.getAggregatedContainersUtilization();
    }

    public ResourceUtilization getNodeUtilization() {
        return this.node.getNodeUtilization();
    }

    public long getUntrackedTimeStamp() {
        return 0L;
    }

    public void setUntrackedTimeStamp(long timeStamp) {
    }

    public Integer getDecommissioningTimeout() {
        return null;
    }

    public Resource getPhysicalResource() {
        return null;
    }
}

