/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.TestStateStoreBase;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RouterHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStateStoreRouterState
extends TestStateStoreBase {
    private static RouterStore routerStore;

    @BeforeClass
    public static void create() {
        TestStateStoreRouterState.getConf().setTimeDuration("dfs.federation.router.store.router.expiration", 5L, TimeUnit.SECONDS);
    }

    @Before
    public void setup() throws IOException, InterruptedException {
        if (routerStore == null) {
            routerStore = (RouterStore)TestStateStoreRouterState.getStateStore().getRegisteredRecordStore(RouterStore.class);
        }
        Assert.assertTrue((boolean)FederationStateStoreTestUtils.clearRecords(TestStateStoreRouterState.getStateStore(), RouterState.class));
    }

    @Test
    public void testStateStoreDisconnected() throws Exception {
        TestStateStoreRouterState.getStateStore().closeDriver();
        Assert.assertEquals((Object)false, (Object)TestStateStoreRouterState.getStateStore().isDriverReady());
        GetRouterRegistrationRequest getSingleRequest = GetRouterRegistrationRequest.newInstance();
        FederationTestUtils.verifyException(routerStore, "getRouterRegistration", StateStoreUnavailableException.class, new Class[]{GetRouterRegistrationRequest.class}, new Object[]{getSingleRequest});
        GetRouterRegistrationsRequest getRequest = GetRouterRegistrationsRequest.newInstance();
        routerStore.loadCache(true);
        FederationTestUtils.verifyException(routerStore, "getRouterRegistrations", StateStoreUnavailableException.class, new Class[]{GetRouterRegistrationsRequest.class}, new Object[]{getRequest});
        RouterHeartbeatRequest hbRequest = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)"test", (long)0L, (RouterServiceState)RouterServiceState.UNINITIALIZED));
        FederationTestUtils.verifyException(routerStore, "routerHeartbeat", StateStoreUnavailableException.class, new Class[]{RouterHeartbeatRequest.class}, new Object[]{hbRequest});
    }

    @Test
    public void testUpdateRouterStatus() throws IllegalStateException, IOException {
        long dateStarted = Time.now();
        String address = "testaddress";
        RouterHeartbeatRequest request = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)address, (long)dateStarted, (RouterServiceState)RouterServiceState.RUNNING));
        Assert.assertTrue((boolean)routerStore.routerHeartbeat(request).getStatus());
        GetRouterRegistrationRequest getRequest = GetRouterRegistrationRequest.newInstance((String)address);
        RouterState record = routerStore.getRouterRegistration(getRequest).getRouter();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((Object)RouterServiceState.RUNNING, (Object)record.getStatus());
        Assert.assertEquals((Object)address, (Object)record.getAddress());
        Assert.assertEquals((Object)FederationUtil.getCompileInfo(), (Object)record.getCompileInfo());
        Assert.assertFalse((boolean)record.getVersion().isEmpty());
    }

    @Test
    public void testRouterStateExpired() throws IOException, InterruptedException {
        long dateStarted = Time.now();
        String address = "testaddress";
        RouterHeartbeatRequest request = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)address, (long)dateStarted, (RouterServiceState)RouterServiceState.RUNNING));
        Assert.assertTrue((boolean)routerStore.routerHeartbeat(request).getStatus());
        GetRouterRegistrationRequest getRequest = GetRouterRegistrationRequest.newInstance((String)address);
        RouterState record = routerStore.getRouterRegistration(getRequest).getRouter();
        Assert.assertNotNull((Object)record);
        Thread.sleep(6000L);
        RouterState r = routerStore.getRouterRegistration(getRequest).getRouter();
        Assert.assertEquals((Object)RouterServiceState.EXPIRED, (Object)r.getStatus());
        Assert.assertTrue((boolean)routerStore.routerHeartbeat(request).getStatus());
        r = routerStore.getRouterRegistration(getRequest).getRouter();
        Assert.assertEquals((Object)RouterServiceState.RUNNING, (Object)r.getStatus());
    }

    @Test
    public void testGetAllRouterStates() throws StateStoreUnavailableException, IOException {
        RouterHeartbeatRequest heartbeatRequest1 = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)"testaddress1", (long)Time.now(), (RouterServiceState)RouterServiceState.RUNNING));
        Assert.assertTrue((boolean)routerStore.routerHeartbeat(heartbeatRequest1).getStatus());
        RouterHeartbeatRequest heartbeatRequest2 = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)"testaddress2", (long)Time.now(), (RouterServiceState)RouterServiceState.RUNNING));
        Assert.assertTrue((boolean)routerStore.routerHeartbeat(heartbeatRequest2).getStatus());
        routerStore.loadCache(true);
        GetRouterRegistrationsRequest request = GetRouterRegistrationsRequest.newInstance();
        List entries = routerStore.getRouterRegistrations(request).getRouters();
        Assert.assertEquals((long)2L, (long)entries.size());
        Collections.sort(entries);
        Assert.assertEquals((Object)"testaddress1", (Object)((RouterState)entries.get(0)).getAddress());
        Assert.assertEquals((Object)"testaddress2", (Object)((RouterState)entries.get(1)).getAddress());
        Assert.assertEquals((Object)RouterServiceState.RUNNING, (Object)((RouterState)entries.get(0)).getStatus());
        Assert.assertEquals((Object)RouterServiceState.RUNNING, (Object)((RouterState)entries.get(1)).getStatus());
    }
}

