/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.array.Array1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.matrix.decomposition.function.ExchangeColumns;
import org.ojalgo.matrix.decomposition.function.NegateColumn;
import org.ojalgo.matrix.decomposition.function.RotateRight;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;

public interface DecompositionStore<N extends Number>
extends PhysicalStore<N>,
RotateRight,
ExchangeColumns,
NegateColumn {
    public void applyCholesky(int var1, BasicArray<N> var2);

    public void applyLDL(int var1, BasicArray<N> var2);

    public void applyLU(int var1, BasicArray<N> var2);

    public Array1D<ComplexNumber> computeInPlaceSchur(PhysicalStore<N> var1, boolean var2);

    public void divideAndCopyColumn(int var1, int var2, BasicArray<N> var3);

    @Override
    default public void exchangeColumns(int colA, int colB) {
        this.exchangeColumns((long)colA, (long)colB);
    }

    public void exchangeHermitian(int var1, int var2);

    public boolean generateApplyAndCopyHouseholderColumn(int var1, int var2, Householder<N> var3);

    public boolean generateApplyAndCopyHouseholderRow(int var1, int var2, Householder<N> var3);

    @Override
    public void rotateRight(int var1, int var2, double var3, double var5);

    public void setToIdentity(int var1);

    @Override
    default public Array1D<N> sliceColumn(long col) {
        return this.sliceColumn(0L, col);
    }

    @Override
    public Array1D<N> sliceColumn(long var1, long var3);

    @Override
    public Array1D<N> sliceDiagonal(long var1, long var3);

    @Override
    public Array1D<N> sliceRange(long var1, long var3);

    @Override
    default public Array1D<N> sliceRow(long row) {
        return this.sliceRow(row, 0L);
    }

    @Override
    public Array1D<N> sliceRow(long var1, long var3);

    public void transformSymmetric(Householder<N> var1);

    public void tred2(BasicArray<N> var1, BasicArray<N> var2, boolean var3);
}

