/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.classic;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.support.BasicHttpServerExpectationDecorator;
import org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.testing.classic.LoggingBHttpServerConnectionFactory;
import org.apache.hc.core5.testing.classic.LoggingExceptionListener;
import org.apache.hc.core5.testing.classic.LoggingHttp1StreamListener;

public class ClassicTestServer {
    private final SSLContext sslContext;
    private final SocketConfig socketConfig;
    private final RequestHandlerRegistry<HttpRequestHandler> registry;
    private final AtomicReference<HttpServer> serverRef;

    public ClassicTestServer(SSLContext sslContext, SocketConfig socketConfig) {
        this.sslContext = sslContext;
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        this.registry = new RequestHandlerRegistry();
        this.serverRef = new AtomicReference();
    }

    public ClassicTestServer(SocketConfig socketConfig) {
        this(null, socketConfig);
    }

    public ClassicTestServer() {
        this(null, null);
    }

    public void registerHandler(String pattern, HttpRequestHandler handler) {
        this.registry.register(null, pattern, (Object)handler);
    }

    public void registerHandlerVirtual(String hostname, String pattern, HttpRequestHandler handler) {
        this.registry.register(hostname, pattern, (Object)handler);
    }

    public int getPort() {
        HttpServer server = this.serverRef.get();
        if (server != null) {
            return server.getLocalPort();
        }
        throw new IllegalStateException("Server not running");
    }

    public InetAddress getInetAddress() {
        HttpServer server = this.serverRef.get();
        if (server != null) {
            return server.getInetAddress();
        }
        throw new IllegalStateException("Server not running");
    }

    public void start(Http1Config http1Config, HttpProcessor httpProcessor, Decorator<HttpServerRequestHandler> handlerDecorator) throws IOException {
        if (this.serverRef.get() == null) {
            BasicHttpServerRequestHandler handler = new BasicHttpServerRequestHandler(this.registry);
            HttpService httpService = new HttpService(httpProcessor != null ? httpProcessor : HttpProcessors.server(), (HttpServerRequestHandler)(handlerDecorator != null ? (HttpServerRequestHandler)handlerDecorator.decorate((Object)handler) : new BasicHttpServerExpectationDecorator((HttpServerRequestHandler)handler)), (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, (Http1StreamListener)LoggingHttp1StreamListener.INSTANCE);
            HttpServer server = new HttpServer(0, httpService, null, this.socketConfig, this.sslContext != null ? this.sslContext.getServerSocketFactory() : ServerSocketFactory.getDefault(), (HttpConnectionFactory)new LoggingBHttpServerConnectionFactory(this.sslContext != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, http1Config != null ? http1Config : Http1Config.DEFAULT, CharCodingConfig.DEFAULT), null, (ExceptionListener)LoggingExceptionListener.INSTANCE);
            if (this.serverRef.compareAndSet(null, server)) {
                server.start();
            }
        } else {
            throw new IllegalStateException("Server already running");
        }
    }

    public void start() throws IOException {
        this.start(null, null, null);
    }

    public void shutdown(CloseMode closeMode) {
        HttpServer server = this.serverRef.getAndSet(null);
        if (server != null) {
            server.close(closeMode);
        }
    }
}

