/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.AsyncServer;
import org.apache.hc.core5.testing.nio.InternalServerProtocolNegotiationStarter;

public class H2TestServer
extends AsyncServer {
    private final SSLContext sslContext;
    private final SSLSessionInitializer sslSessionInitializer;
    private final SSLSessionVerifier sslSessionVerifier;
    private final RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>> registry;

    public H2TestServer(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.sslSessionInitializer = sslSessionInitializer;
        this.sslSessionVerifier = sslSessionVerifier;
        this.registry = new RequestHandlerRegistry();
    }

    public H2TestServer() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    public void register(String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        this.registry.register(null, uriPattern, supplier);
    }

    public <T> void register(String uriPattern, final AsyncServerRequestHandler<T> requestHandler) {
        this.register(uriPattern, new Supplier<AsyncServerExchangeHandler>(){

            public AsyncServerExchangeHandler get() {
                return new BasicServerExchangeHandler(requestHandler);
            }
        });
    }

    public void start(IOEventHandlerFactory handlerFactory) throws IOException {
        this.execute(handlerFactory);
    }

    public InetSocketAddress start(HttpProcessor httpProcessor, Decorator<AsyncServerExchangeHandler> exchangeHandlerDecorator, H2Config h2Config) throws Exception {
        this.start(new InternalServerProtocolNegotiationStarter(httpProcessor != null ? httpProcessor : H2Processors.server(), (HandlerFactory<AsyncServerExchangeHandler>)new DefaultAsyncResponseExchangeHandlerFactory(this.registry, (Decorator)(exchangeHandlerDecorator != null ? exchangeHandlerDecorator : new Decorator<AsyncServerExchangeHandler>(){

            public AsyncServerExchangeHandler decorate(AsyncServerExchangeHandler handler) {
                return new BasicAsyncServerExpectationDecorator(handler);
            }
        })), HttpVersionPolicy.FORCE_HTTP_2, h2Config, Http1Config.DEFAULT, CharCodingConfig.DEFAULT, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier));
        Future<ListenerEndpoint> future = this.listen(new InetSocketAddress(0));
        ListenerEndpoint listener = future.get();
        return (InetSocketAddress)listener.getAddress();
    }

    public InetSocketAddress start(HttpProcessor httpProcessor, Decorator<AsyncServerExchangeHandler> exchangeHandlerDecorator, Http1Config http1Config) throws Exception {
        this.start(new InternalServerProtocolNegotiationStarter(httpProcessor != null ? httpProcessor : HttpProcessors.server(), (HandlerFactory<AsyncServerExchangeHandler>)new DefaultAsyncResponseExchangeHandlerFactory(this.registry, (Decorator)(exchangeHandlerDecorator != null ? exchangeHandlerDecorator : new Decorator<AsyncServerExchangeHandler>(){

            public AsyncServerExchangeHandler decorate(AsyncServerExchangeHandler handler) {
                return new BasicAsyncServerExpectationDecorator(handler);
            }
        })), HttpVersionPolicy.FORCE_HTTP_1, H2Config.DEFAULT, http1Config, CharCodingConfig.DEFAULT, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier));
        Future<ListenerEndpoint> future = this.listen(new InetSocketAddress(0));
        ListenerEndpoint listener = future.get();
        return (InetSocketAddress)listener.getAddress();
    }

    public InetSocketAddress start(H2Config h2Config) throws Exception {
        return this.start(null, null, h2Config);
    }

    public InetSocketAddress start(Http1Config http1Config) throws Exception {
        return this.start(null, null, http1Config);
    }

    public InetSocketAddress start() throws Exception {
        return this.start(H2Config.DEFAULT);
    }
}

