/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.classic;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hc.client5.testing.auth.AuthResult;
import org.apache.hc.client5.testing.auth.AuthenticationHandler;
import org.apache.hc.client5.testing.auth.Authenticator;
import org.apache.hc.client5.testing.auth.BasicAuthenticationHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

public class AuthenticatingDecorator
implements HttpServerRequestHandler {
    private final HttpServerRequestHandler requestHandler;
    private final AuthenticationHandler<String> authenticationHandler;
    private final Authenticator authenticator;

    public AuthenticatingDecorator(HttpServerRequestHandler requestHandler, AuthenticationHandler<String> authenticationHandler, Authenticator authenticator) {
        this.requestHandler = (HttpServerRequestHandler)Args.notNull((Object)requestHandler, (String)"Request handler");
        this.authenticationHandler = (AuthenticationHandler)Args.notNull(authenticationHandler, (String)"Authentication handler");
        this.authenticator = (Authenticator)Args.notNull((Object)authenticator, (String)"Authenticator");
    }

    public AuthenticatingDecorator(HttpServerRequestHandler requestHandler, Authenticator authenticator) {
        this(requestHandler, new BasicAuthenticationHandler(StandardCharsets.US_ASCII), authenticator);
    }

    protected void customizeUnauthorizedResponse(ClassicHttpResponse unauthorized) {
    }

    public void handle(ClassicHttpRequest request, HttpServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
        boolean expectContinue;
        Header h = request.getFirstHeader("Authorization");
        String challengeResponse = h != null ? this.authenticationHandler.extractAuthToken(h.getValue()) : null;
        URIAuthority authority = request.getAuthority();
        String requestUri = request.getRequestUri();
        AuthResult authResult = this.authenticator.perform(authority, requestUri, challengeResponse);
        Header expect = request.getFirstHeader("Expect");
        boolean bl = expectContinue = expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
        if (authResult.isSuccess()) {
            if (expectContinue) {
                responseTrigger.sendInformation((ClassicHttpResponse)new BasicClassicHttpResponse(100));
            }
            this.requestHandler.handle(request, responseTrigger, context);
        } else {
            BasicClassicHttpResponse unauthorized = new BasicClassicHttpResponse(401);
            ArrayList<NameValuePair> challengeParams = new ArrayList<NameValuePair>();
            String realm = this.authenticator.getRealm(authority, requestUri);
            if (realm != null) {
                challengeParams.add((NameValuePair)new BasicNameValuePair("realm", realm));
            }
            if (authResult.hasParams()) {
                challengeParams.addAll(authResult.getParams());
            }
            String challenge = this.authenticationHandler.challenge(challengeParams);
            unauthorized.addHeader("WWW-Authenticate", (Object)challenge);
            this.customizeUnauthorizedResponse((ClassicHttpResponse)unauthorized);
            if (unauthorized.getEntity() == null) {
                unauthorized.setEntity((HttpEntity)new StringEntity("Unauthorized"));
            }
            if (expectContinue || request.getEntity() == null) {
                responseTrigger.submitResponse((ClassicHttpResponse)unauthorized);
                EntityUtils.consume((HttpEntity)request.getEntity());
            } else {
                EntityUtils.consume((HttpEntity)request.getEntity());
                responseTrigger.submitResponse((ClassicHttpResponse)unauthorized);
            }
        }
    }
}

