/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.routing;

import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.MisdirectedRequestException;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.net.URIAuthority;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRequestRouter {
    TestRequestRouter() {
    }

    @Test
    void testRequestRouting() throws Exception {
        RequestRouter requestRouter = RequestRouter.builder((UriPatternType)UriPatternType.URI_PATTERN).addRoute("somehost.somedomain", "/*", (Object)0L).addRoute("someotherhost.somedomain", "/foo/*", (Object)1L).addRoute("somehost.somedomain", "/foo/*", (Object)2L).addRoute("somehost.somedomain", "/bar/*", (Object)3L).addRoute("somehost.somedomain", "/stuff", (Object)4L).build();
        HttpCoreContext context = HttpCoreContext.create();
        Assertions.assertEquals((long)1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://someotherhost.somedomain/foo/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)2L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost.somedomain/foo/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)3L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost.somedomain/bar/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)4L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost.somedomain/stuff").build(), (HttpContext)context)));
        Assertions.assertEquals((long)4L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost.somedomain/stuff?huh").build(), (HttpContext)context)));
        Assertions.assertEquals((long)0L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost.somedomain/stuffed").build(), (HttpContext)context)));
        Assertions.assertNull((Object)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://someotherhost.somedomain/stuff").build(), (HttpContext)context));
        Assertions.assertThrows(MisdirectedRequestException.class, () -> {
            Long cfr_ignored_0 = (Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehere.in.pampa/stuff").build(), (HttpContext)context);
        });
    }

    @Test
    void testDefaultAuthorityResolution() throws Exception {
        RequestRouter requestRouter = RequestRouter.builder((UriPatternType)UriPatternType.URI_PATTERN).addRoute(new URIAuthority("somehost", -1), "/*", (Object)0L).addRoute(new URIAuthority("somehost", 80), "/*", (Object)1L).addRoute(new URIAuthority("somehost", 8080), "/*", (Object)2L).addRoute(new URIAuthority("someotherhost", 80), "/*", (Object)10L).build();
        HttpCoreContext context = HttpCoreContext.create();
        Assertions.assertEquals((long)0L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)10L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://someotherhost:80/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost:80/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)2L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost:8080/blah").build(), (HttpContext)context)));
        Assertions.assertThrows(MisdirectedRequestException.class, () -> {
            Long cfr_ignored_0 = (Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehere.in.pampa/stuff").build(), (HttpContext)context);
        });
    }

    @Test
    void testCustomAuthorityResolution() throws Exception {
        RequestRouter requestRouter = RequestRouter.builder((UriPatternType)UriPatternType.URI_PATTERN).addRoute(new URIAuthority("somehost", -1), "/*", (Object)1L).addRoute(new URIAuthority("someotherhost", -1), "/*", (Object)2L).resolveAuthority((scheme, authority) -> authority != null ? new URIAuthority(authority.getHostName(), -1) : new URIAuthority("somehost")).build();
        HttpCoreContext context = HttpCoreContext.create();
        Assertions.assertEquals((long)1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)2L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://someotherhost:80/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost:80/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost:8080/blah").build(), (HttpContext)context)));
        Assertions.assertEquals((long)1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"/blah").build(), (HttpContext)context)));
        Assertions.assertThrows(MisdirectedRequestException.class, () -> {
            Long cfr_ignored_0 = (Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehere.in.pampa/stuff").build(), (HttpContext)context);
        });
    }

    @Test
    void testDownstreamResolution() throws Exception {
        RequestRouter requestRouter = RequestRouter.builder((UriPatternType)UriPatternType.URI_PATTERN).addRoute(new URIAuthority("somehost", 80), "/*", (Object)1L).addRoute(new URIAuthority("someotherhost", 80), "/*", (Object)10L).resolveAuthority((scheme, authority) -> authority).downstream((request, context) -> -1L).build();
        HttpCoreContext context2 = HttpCoreContext.create();
        Assertions.assertEquals((long)-1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost/blah").build(), (HttpContext)context2)));
        Assertions.assertEquals((long)10L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://someotherhost:80/blah").build(), (HttpContext)context2)));
        Assertions.assertEquals((long)1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost:80/blah").build(), (HttpContext)context2)));
        Assertions.assertEquals((long)-1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehost:8080/blah").build(), (HttpContext)context2)));
        Assertions.assertEquals((long)-1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"/blah").build(), (HttpContext)context2)));
        Assertions.assertEquals((long)-1L, (Long)((Long)requestRouter.resolve((HttpRequest)BasicRequestBuilder.get((String)"http://somehere.in.pampa/stuff").build(), (HttpContext)context2)));
    }
}

