/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.http.impl.nio.AbstractHttp1StreamDuplexer;
import org.apache.hc.core5.reactor.IOSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class TestAbstractHttp1StreamDuplexerCapacityWindow {
    @Mock
    private IOSession ioSession;
    private AutoCloseable closeable;

    TestAbstractHttp1StreamDuplexerCapacityWindow() {
    }

    @BeforeEach
    void prepareMocks() {
        this.closeable = MockitoAnnotations.openMocks((Object)this);
    }

    @AfterEach
    void releaseMocks() throws Exception {
        this.closeable.close();
    }

    @Test
    void testWindowUpdate() throws IOException {
        AbstractHttp1StreamDuplexer.CapacityWindow window = new AbstractHttp1StreamDuplexer.CapacityWindow(0, this.ioSession);
        window.update(1);
        Assertions.assertEquals((int)1, (int)window.getWindow());
        ((IOSession)Mockito.verify((Object)this.ioSession)).setEvent(ArgumentMatchers.eq((int)1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ioSession});
    }

    @Test
    void testRemoveCapacity() {
        AbstractHttp1StreamDuplexer.CapacityWindow window = new AbstractHttp1StreamDuplexer.CapacityWindow(1, this.ioSession);
        window.removeCapacity(1);
        Assertions.assertEquals((int)0, (int)window.getWindow());
        ((IOSession)Mockito.verify((Object)this.ioSession)).clearEvent(ArgumentMatchers.eq((int)1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ioSession});
    }

    @Test
    void noReadsSetAfterWindowIsClosed() throws IOException {
        AbstractHttp1StreamDuplexer.CapacityWindow window = new AbstractHttp1StreamDuplexer.CapacityWindow(1, this.ioSession);
        window.close();
        window.update(1);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.ioSession});
    }

    @Test
    void windowCannotUnderflow() {
        AbstractHttp1StreamDuplexer.CapacityWindow window = new AbstractHttp1StreamDuplexer.CapacityWindow(Integer.MIN_VALUE, this.ioSession);
        window.removeCapacity(1);
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)window.getWindow());
    }

    @Test
    void windowCannotOverflow() throws IOException {
        AbstractHttp1StreamDuplexer.CapacityWindow window = new AbstractHttp1StreamDuplexer.CapacityWindow(Integer.MAX_VALUE, this.ioSession);
        window.update(1);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)window.getWindow());
    }

    @Test
    void noChangesIfUpdateIsNonPositive() throws IOException {
        AbstractHttp1StreamDuplexer.CapacityWindow window = new AbstractHttp1StreamDuplexer.CapacityWindow(1, this.ioSession);
        window.update(0);
        window.update(-1);
        Assertions.assertEquals((int)1, (int)window.getWindow());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.ioSession});
    }
}

