/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SafeMaybeObserver<T>
implements MaybeObserver<T> {
    final MaybeObserver<? super T> downstream;
    boolean onSubscribeFailed;

    public SafeMaybeObserver(MaybeObserver<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(@NonNull Disposable d) {
        try {
            this.downstream.onSubscribe(d);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            this.onSubscribeFailed = true;
            d.dispose();
            RxJavaPlugins.onError(ex);
        }
    }

    @Override
    public void onSuccess(@NonNull T t) {
        if (!this.onSubscribeFailed) {
            try {
                this.downstream.onSuccess(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }
    }

    @Override
    public void onError(@NonNull Throwable e) {
        if (this.onSubscribeFailed) {
            RxJavaPlugins.onError(e);
        } else {
            try {
                this.downstream.onError(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(new CompositeException(e, ex));
            }
        }
    }

    @Override
    public void onComplete() {
        if (!this.onSubscribeFailed) {
            try {
                this.downstream.onComplete();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }
    }
}

