/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.hc.core5.http.HttpStatus;
import org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestEnglishReasonPhraseCatalog {
    TestEnglishReasonPhraseCatalog() {
    }

    @Test
    void testReasonPhrases() throws IllegalAccessException {
        Field[] publicFields = HttpStatus.class.getFields();
        Assertions.assertNotNull((Object)publicFields);
        Assertions.assertTrue((publicFields.length > 0 ? 1 : 0) != 0);
        for (Field f : publicFields) {
            int modifiers = f.getModifiers();
            if (f.getType() != Integer.TYPE || !Modifier.isPublic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers)) continue;
            int iValue = f.getInt(null);
            String text = EnglishReasonPhraseCatalog.INSTANCE.getReason(iValue, null);
            Assertions.assertNotNull((Object)("text is null for HttpStatus." + f.getName()), (String)text);
            Assertions.assertTrue((text.length() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    void testStatusInvalid() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnglishReasonPhraseCatalog.INSTANCE.getReason(-1, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnglishReasonPhraseCatalog.INSTANCE.getReason(99, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EnglishReasonPhraseCatalog.INSTANCE.getReason(600, null));
    }

    @Test
    void testStatusAll() {
        for (int i = 100; i < 600; ++i) {
            EnglishReasonPhraseCatalog.INSTANCE.getReason(i, null);
        }
    }
}

