/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.registry.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.configuration.JsonString;
import org.apache.ignite3.internal.cli.call.configuration.NodeConfigShowCall;
import org.apache.ignite3.internal.cli.call.configuration.NodeConfigShowCallInput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.repl.SessionInfo;
import org.apache.ignite3.internal.cli.core.repl.registry.NodeConfigRegistry;
import org.apache.ignite3.internal.cli.core.repl.registry.impl.LazyObjectRef;
import org.apache.ignite3.internal.cli.event.ConnectionEventListener;
import org.jetbrains.annotations.Nullable;

@Singleton
public class NodeConfigRegistryImpl
implements NodeConfigRegistry,
ConnectionEventListener {
    private final NodeConfigShowCall nodeConfigShowCall;
    @Nullable
    private LazyObjectRef<Config> configRef;

    public NodeConfigRegistryImpl(NodeConfigShowCall nodeConfigShowCall) {
        this.nodeConfigShowCall = nodeConfigShowCall;
    }

    @Override
    public void onConnect(SessionInfo sessionInfo) {
        this.configRef = new LazyObjectRef<Config>(() -> this.fetchConfig(sessionInfo));
    }

    @Nullable
    private Config fetchConfig(SessionInfo sessionInfo) {
        DefaultCallOutput<JsonString> result = this.nodeConfigShowCall.execute(NodeConfigShowCallInput.builder().nodeUrl(sessionInfo.nodeUrl()).build());
        if (result.hasError()) {
            return null;
        }
        return ConfigFactory.parseString((String)result.body().getValue());
    }

    @Override
    public void onDisconnect() {
        this.configRef = null;
    }

    @Override
    @Nullable
    public Config config() {
        return this.configRef == null ? null : this.configRef.get();
    }
}

