/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbIndexes;
import org.apache.ignite3.internal.storage.rocksdb.index.AbstractRocksDbIndexStorage;
import org.apache.ignite3.internal.storage.rocksdb.instance.SharedRocksDbInstance;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;

abstract class Index<S extends AbstractRocksDbIndexStorage> {
    private final int tableId;
    private final int indexId;
    private final ColumnFamily columnFamily;
    private final ConcurrentMap<Integer, S> storageByPartitionId = new ConcurrentHashMap<Integer, S>();

    Index(int tableId, int indexId, ColumnFamily cf) {
        this.tableId = tableId;
        this.indexId = indexId;
        this.columnFamily = cf;
    }

    int tableId() {
        return this.tableId;
    }

    int indexId() {
        return this.indexId;
    }

    ColumnFamily columnFamily() {
        return this.columnFamily;
    }

    @Nullable
    S getStorage(int partitionId) {
        return (S)((AbstractRocksDbIndexStorage)this.storageByPartitionId.get(partitionId));
    }

    S getOrCreateStorage(int partitionId) {
        return (S)this.storageByPartitionId.computeIfAbsent(partitionId, this::createStorage);
    }

    abstract S createStorage(int var1);

    final void close() {
        try {
            IgniteUtils.closeAll(this.storageByPartitionId.values().stream().map(index -> index::close));
        }
        catch (Exception e) {
            throw new StorageException("Failed to close index storages: " + this.indexId, (Throwable)e);
        }
    }

    void transitionToDestroyedState() {
        try {
            IgniteUtils.closeAll(this.storageByPartitionId.values().stream().map(index -> index::transitionToDestroyedState));
        }
        catch (Exception e) {
            throw new StorageException("Failed to transition index storages to the DESTROYED state: " + this.indexId, (Throwable)e);
        }
    }

    void destroy(int partitionId, WriteBatch writeBatch) throws RocksDBException {
        AbstractRocksDbIndexStorage storage = (AbstractRocksDbIndexStorage)this.storageByPartitionId.remove(partitionId);
        if (storage != null) {
            storage.transitionToDestroyedState();
            storage.destroyData(writeBatch);
        }
    }

    void destroy(WriteBatch writeBatch) throws RocksDBException {
        this.transitionToDestroyedState();
        SharedRocksDbInstance.deleteByPrefix(writeBatch, this.columnFamily, RocksDbIndexes.indexPrefix(this.tableId, this.indexId));
    }
}

