/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition.executor.hash;

import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;

public class APHashExecutor
extends SeriesPartitionExecutor {
    public APHashExecutor(int deviceGroupCount) {
        super(deviceGroupCount);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(String device) {
        int hash = 0;
        for (int i = 0; i < device.length(); ++i) {
            if ((i & 1) == 0) {
                hash ^= hash << 7 ^ device.charAt(i) ^ hash >> 3;
                continue;
            }
            hash ^= ~(hash << 11 ^ device.charAt(i) ^ hash >> 5);
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }
}

