/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CreateModelPlan
extends ConfigPhysicalPlan {
    private String modelName;

    public CreateModelPlan() {
        super(ConfigPhysicalPlanType.CreateModel);
    }

    public CreateModelPlan(String modelName) {
        super(ConfigPhysicalPlanType.CreateModel);
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.modelName, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.modelName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CreateModelPlan that = (CreateModelPlan)o;
        return Objects.equals(this.modelName, that.modelName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelName);
    }
}

