/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TPipeHeartbeatResp;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeAsyncRequestRPCHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHeartbeatRPCHandler
extends DataNodeAsyncRequestRPCHandler<TPipeHeartbeatResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHeartbeatRPCHandler.class);

    public PipeHeartbeatRPCHandler(CnToDnAsyncRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TPipeHeartbeatResp> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TPipeHeartbeatResp response) {
        this.responseMap.put(this.requestId, response);
        this.nodeLocationMap.remove(this.requestId);
        LOGGER.debug("Successfully {} on DataNode: {}", this.requestType, (Object)this.formattedTargetLocation);
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        LOGGER.error("Failed to {} on DataNode: {}, exception: {}", new Object[]{this.requestType, this.formattedTargetLocation, e.getMessage()});
        this.countDownLatch.countDown();
    }
}

