/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tsfile.encoding.bitpacking.LongPacker;
import org.apache.tsfile.encoding.encoder.RleEncoder;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class LongRleEncoder
extends RleEncoder<Long> {
    private LongPacker packer;

    public LongRleEncoder() {
        this.bufferedValues = new Long[8];
        this.preValue = Long.valueOf(0L);
        this.values = new ArrayList();
    }

    @Override
    public void encode(long value, ByteArrayOutputStream out) {
        this.values.add(value);
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        this.bitWidth = ReadWriteForEncodingUtils.getLongMaxBitWidth(this.values);
        this.packer = new LongPacker(this.bitWidth);
        for (Long value : this.values) {
            this.encodeValue(value);
        }
        super.flush(out);
    }

    @Override
    protected void reset() {
        super.reset();
        this.preValue = Long.valueOf(0L);
    }

    @Override
    protected void writeRleRun() throws IOException {
        this.endPreviousBitPackedRun(8);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(this.repeatCount << 1, this.byteCache);
        ReadWriteForEncodingUtils.writeLongLittleEndianPaddedOnBitWidth((Long)this.preValue, this.byteCache, this.bitWidth);
        this.repeatCount = 0;
        this.numBufferedValues = 0;
    }

    @Override
    protected void clearBuffer() {
        for (int i = this.numBufferedValues; i < 8; ++i) {
            ((Long[])this.bufferedValues)[i] = 0L;
        }
    }

    @Override
    protected void convertBuffer() {
        byte[] bytes = new byte[this.bitWidth];
        long[] tmpBuffer = new long[8];
        for (int i = 0; i < 8; ++i) {
            tmpBuffer[i] = ((Long[])this.bufferedValues)[i];
        }
        this.packer.pack8Values(tmpBuffer, 0, bytes);
        this.bytesBuffer.add(bytes);
    }

    @Override
    public int getOneItemMaxSize() {
        return 77;
    }

    @Override
    public long getMaxByteSize() {
        if (this.values == null) {
            return 0L;
        }
        int groupNum = (this.values.size() / 8 + 1) / 63 + 1;
        return 8L + (long)(groupNum * 5) + (long)(this.values.size() * 8);
    }
}

