/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.container.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.util.ModsOperationUtil;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.TsFileReader;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.read.expression.IExpression;
import org.apache.tsfile.read.expression.QueryExpression;
import org.apache.tsfile.read.query.dataset.QueryDataSet;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class TsFileInsertionQueryDataTabletIterator
implements Iterator<Tablet> {
    private final TsFileReader tsFileReader;
    private final Map<String, TSDataType> measurementDataTypeMap;
    private final String deviceId;
    private final List<String> measurements;
    private final IExpression timeFilterExpression;
    private final QueryDataSet queryDataSet;
    private final PipeMemoryBlock allocatedBlockForTablet;
    private final List<ModsOperationUtil.ModsInfo> measurementModsList;
    private RowRecord rowRecord;

    TsFileInsertionQueryDataTabletIterator(TsFileReader tsFileReader, Map<String, TSDataType> measurementDataTypeMap, String deviceId, List<String> measurements, IExpression timeFilterExpression, PipeMemoryBlock allocatedBlockForTablet, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> currentModifications) throws IOException {
        this.tsFileReader = tsFileReader;
        this.measurementDataTypeMap = measurementDataTypeMap;
        this.deviceId = deviceId;
        this.measurements = measurements.stream().filter(measurement -> measurement != null && !measurement.isEmpty()).sorted().collect(Collectors.toList());
        this.timeFilterExpression = timeFilterExpression;
        this.queryDataSet = this.buildQueryDataSet();
        this.allocatedBlockForTablet = Objects.requireNonNull(allocatedBlockForTablet);
        this.measurementModsList = ModsOperationUtil.initializeMeasurementMods(deviceId, this.measurements, currentModifications);
    }

    private QueryDataSet buildQueryDataSet() throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String measurement : this.measurements) {
            paths.add(new Path(this.deviceId, measurement, false));
        }
        return this.tsFileReader.query(QueryExpression.create(paths, (IExpression)this.timeFilterExpression));
    }

    @Override
    public boolean hasNext() {
        try {
            return this.queryDataSet.hasNext();
        }
        catch (IOException e) {
            throw new PipeException("Failed to check next", (Throwable)e);
        }
    }

    @Override
    public Tablet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return this.buildNextTablet();
        }
        catch (IOException e) {
            throw new PipeException("Failed to build tablet", (Throwable)e);
        }
    }

    private Tablet buildNextTablet() throws IOException {
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        for (String measurement : this.measurements) {
            TSDataType dataType = this.measurementDataTypeMap.get(this.deviceId + "." + measurement);
            schemas.add(new MeasurementSchema(measurement, dataType));
        }
        Tablet tablet = null;
        if (!this.queryDataSet.hasNext()) {
            tablet = new Tablet(this.deviceId, schemas, 1);
            tablet.initBitMaps();
            return tablet;
        }
        boolean isFirstRow = true;
        while (this.queryDataSet.hasNext()) {
            RowRecord rowRecord;
            RowRecord rowRecord2 = rowRecord = this.rowRecord != null ? this.rowRecord : this.queryDataSet.next();
            if (isFirstRow) {
                this.rowRecord = rowRecord;
                Pair<Integer, Integer> rowCountAndMemorySize = PipeMemoryWeightUtil.calculateTabletRowCountAndMemory(rowRecord);
                tablet = new Tablet(this.deviceId, schemas, ((Integer)rowCountAndMemorySize.getLeft()).intValue());
                tablet.initBitMaps();
                if (this.allocatedBlockForTablet.getMemoryUsageInBytes() < (long)((Integer)rowCountAndMemorySize.getRight()).intValue()) {
                    PipeDataNodeResourceManager.memory().forceResize(this.allocatedBlockForTablet, ((Integer)rowCountAndMemorySize.getRight()).intValue());
                }
                this.rowRecord = null;
                isFirstRow = false;
            }
            int rowIndex = tablet.rowSize;
            boolean isNeedFillTime = false;
            List fields = rowRecord.getFields();
            int fieldSize = fields.size();
            for (int i = 0; i < fieldSize; ++i) {
                Field field = (Field)fields.get(i);
                String measurement = this.measurements.get(i);
                if (field == null || ModsOperationUtil.isDelete(rowRecord.getTimestamp(), this.measurementModsList.get(i))) {
                    tablet.bitMaps[i].mark(rowIndex);
                    continue;
                }
                tablet.addValue(measurement, rowIndex, field.getObjectValue(((MeasurementSchema)schemas.get(i)).getType()));
                isNeedFillTime = true;
            }
            if (isNeedFillTime) {
                tablet.addTimestamp(rowIndex, rowRecord.getTimestamp());
            }
            ++tablet.rowSize;
            if (tablet.rowSize != tablet.getMaxRowNumber()) continue;
            break;
        }
        return tablet;
    }
}

